@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
 */
public enum class VideoScaleMode(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode> {
    /**
     * Pads the video with black horizontal stripes (letterbox) or black vertical stripes (pillar-box) so the video is resized to the specified dimensions while not altering the content aspect ratio.
     */
    Pad(com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode.Pad),

    /**
     * Preserves the same aspect ratio as the input video. If only one video dimension is provided, the second dimension is calculated based on the input video aspect ratio. When 2 dimensions are provided, the video is resized to fit the most constraining dimension, considering the input video size and aspect ratio.
     */
    PreserveAspectRatio(com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode.PreserveAspectRatio),

    /**
     * Stretches the original video so it resized to the specified dimensions.
     */
    Stretch(com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode.Stretch),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.VideoScaleMode):
            VideoScaleMode = VideoScaleMode.values().first { it.javaValue == javaType }
    }
}
