@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GetVideoPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Azure Video Analyzer account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property videoName The Video name.
 */
public data class GetVideoPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val videoName: String,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GetVideoPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GetVideoPlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GetVideoPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .videoName(videoName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVideoPlainArgs].
 */
@PulumiTagMarker
public class GetVideoPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var videoName: String? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("dmnvucxuapcvlsrm")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqowfgstvabjjnhs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Video name.
     */
    @JvmName("bmetabxmswhaogsx")
    public suspend fun videoName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.videoName = mapped
    }

    internal fun build(): GetVideoPlainArgs = GetVideoPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        videoName = videoName ?: throw PulumiNullFieldException("videoName"),
    )
}
