@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.ListEdgeModuleProvisioningTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Azure Video Analyzer account name.
 * @property edgeModuleName The Edge Module name.
 * @property expirationDate The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListEdgeModuleProvisioningTokenPlainArgs(
    public val accountName: String,
    public val edgeModuleName: String,
    public val expirationDate: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.ListEdgeModuleProvisioningTokenPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.videoanalyzer.inputs.ListEdgeModuleProvisioningTokenPlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.ListEdgeModuleProvisioningTokenPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .edgeModuleName(edgeModuleName.let({ args0 -> args0 }))
            .expirationDate(expirationDate.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListEdgeModuleProvisioningTokenPlainArgs].
 */
@PulumiTagMarker
public class ListEdgeModuleProvisioningTokenPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var edgeModuleName: String? = null

    private var expirationDate: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("jkjpyrrphgtiuaao")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Edge Module name.
     */
    @JvmName("wbswlyayenbcfota")
    public suspend fun edgeModuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeModuleName = mapped
    }

    /**
     * @param value The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
     */
    @JvmName("hjtwowjnoqphlrdx")
    public suspend fun expirationDate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expirationDate = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mconnrkbktpkwchq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListEdgeModuleProvisioningTokenPlainArgs =
        ListEdgeModuleProvisioningTokenPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            edgeModuleName = edgeModuleName ?: throw PulumiNullFieldException("edgeModuleName"),
            expirationDate = expirationDate ?: throw PulumiNullFieldException("expirationDate"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
