@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.RsaTokenKeyArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.AccessPolicyRsaAlgo
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Required validation properties for tokens generated with RSA algorithm.
 * @property alg RSA algorithm to be used: RS256, RS384 or RS512.
 * @property e RSA public key exponent.
 * @property kid JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
 * @property n RSA public key modulus.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
 */
public data class RsaTokenKeyArgs(
    public val alg: Output<Either<String, AccessPolicyRsaAlgo>>,
    public val e: Output<String>,
    public val kid: Output<String>,
    public val n: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.RsaTokenKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.RsaTokenKeyArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.RsaTokenKeyArgs.builder()
            .alg(
                alg.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .e(e.applyValue({ args0 -> args0 }))
            .kid(kid.applyValue({ args0 -> args0 }))
            .n(n.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RsaTokenKeyArgs].
 */
@PulumiTagMarker
public class RsaTokenKeyArgsBuilder internal constructor() {
    private var alg: Output<Either<String, AccessPolicyRsaAlgo>>? = null

    private var e: Output<String>? = null

    private var kid: Output<String>? = null

    private var n: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value RSA algorithm to be used: RS256, RS384 or RS512.
     */
    @JvmName("auummydtmtrbytbx")
    public suspend fun alg(`value`: Output<Either<String, AccessPolicyRsaAlgo>>) {
        this.alg = value
    }

    /**
     * @param value RSA public key exponent.
     */
    @JvmName("sxgwiorgxiccgdyd")
    public suspend fun e(`value`: Output<String>) {
        this.e = value
    }

    /**
     * @param value JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
     */
    @JvmName("hvfqhoxukqqwxvka")
    public suspend fun kid(`value`: Output<String>) {
        this.kid = value
    }

    /**
     * @param value RSA public key modulus.
     */
    @JvmName("ugbncmlnoncllsmc")
    public suspend fun n(`value`: Output<String>) {
        this.n = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
     */
    @JvmName("metpcyxarcxvaeru")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value RSA algorithm to be used: RS256, RS384 or RS512.
     */
    @JvmName("tmvggvjadikcufkr")
    public suspend fun alg(`value`: Either<String, AccessPolicyRsaAlgo>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value RSA algorithm to be used: RS256, RS384 or RS512.
     */
    @JvmName("vseyvmamfmkuyaql")
    public fun alg(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessPolicyRsaAlgo>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value RSA algorithm to be used: RS256, RS384 or RS512.
     */
    @JvmName("rsjknoynuujdxiwj")
    public fun alg(`value`: AccessPolicyRsaAlgo) {
        val toBeMapped = Either.ofRight<String, AccessPolicyRsaAlgo>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value RSA public key exponent.
     */
    @JvmName("bwchulbkbcgukmxp")
    public suspend fun e(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.e = mapped
    }

    /**
     * @param value JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
     */
    @JvmName("lwxhcbhtrfimyugr")
    public suspend fun kid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kid = mapped
    }

    /**
     * @param value RSA public key modulus.
     */
    @JvmName("krwmlljqcsscfybo")
    public suspend fun n(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.n = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
     */
    @JvmName("abxsunwcasiakxwr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RsaTokenKeyArgs = RsaTokenKeyArgs(
        alg = alg ?: throw PulumiNullFieldException("alg"),
        e = e ?: throw PulumiNullFieldException("e"),
        kid = kid ?: throw PulumiNullFieldException("kid"),
        n = n ?: throw PulumiNullFieldException("n"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
