@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoEncoderH264Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A custom preset for encoding video with the H.264 (AVC) codec.
 * @property bitrateKbps The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
 * @property frameRate The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
 * @property scale Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
 */
public data class VideoEncoderH264Args(
    public val bitrateKbps: Output<String>? = null,
    public val frameRate: Output<String>? = null,
    public val scale: Output<VideoScaleArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoEncoderH264Args> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoEncoderH264Args =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoEncoderH264Args.builder()
            .bitrateKbps(bitrateKbps?.applyValue({ args0 -> args0 }))
            .frameRate(frameRate?.applyValue({ args0 -> args0 }))
            .scale(scale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoEncoderH264Args].
 */
@PulumiTagMarker
public class VideoEncoderH264ArgsBuilder internal constructor() {
    private var bitrateKbps: Output<String>? = null

    private var frameRate: Output<String>? = null

    private var scale: Output<VideoScaleArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
     */
    @JvmName("oxpdhwrhiihcqfbc")
    public suspend fun bitrateKbps(`value`: Output<String>) {
        this.bitrateKbps = value
    }

    /**
     * @param value The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
     */
    @JvmName("eyghjiqttntqkwwo")
    public suspend fun frameRate(`value`: Output<String>) {
        this.frameRate = value
    }

    /**
     * @param value Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
     */
    @JvmName("vteeunpeoksjrfio")
    public suspend fun scale(`value`: Output<VideoScaleArgs>) {
        this.scale = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
     */
    @JvmName("psnjjolmddnbldou")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
     */
    @JvmName("sqdqnqupqhjntorw")
    public suspend fun bitrateKbps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrateKbps = mapped
    }

    /**
     * @param value The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
     */
    @JvmName("mydgnpkhwhlkweef")
    public suspend fun frameRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameRate = mapped
    }

    /**
     * @param value Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
     */
    @JvmName("wcryjxrltxpfyqcv")
    public suspend fun scale(`value`: VideoScaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param argument Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
     */
    @JvmName("gmseuumxwaoaobng")
    public suspend fun scale(argument: suspend VideoScaleArgsBuilder.() -> Unit) {
        val toBeMapped = VideoScaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scale = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
     */
    @JvmName("qdxrfwahtypcltbp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VideoEncoderH264Args = VideoEncoderH264Args(
        bitrateKbps = bitrateKbps,
        frameRate = frameRate,
        scale = scale,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
