@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.Suppress

/**
 * Network access control for video analyzer account.
 * @property consumption Public network access for consumption group.
 * @property ingestion Public network access for ingestion group.
 * @property integration Public network access for integration group.
 */
public data class NetworkAccessControlResponse(
    public val consumption: GroupLevelAccessControlResponse? = null,
    public val ingestion: GroupLevelAccessControlResponse? = null,
    public val integration: GroupLevelAccessControlResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.NetworkAccessControlResponse):
            NetworkAccessControlResponse = NetworkAccessControlResponse(
            consumption = javaType.consumption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.GroupLevelAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ingestion = javaType.ingestion().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.GroupLevelAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            integration = javaType.integration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.GroupLevelAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
