@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Single topology parameter declaration. Declared parameters can and must be referenced throughout the topology and can optionally have default values to be used when they are not defined in the pipelines.
 * @property default The default value for the parameter to be used if the pipeline does not specify a value.
 * @property description Description of the parameter.
 * @property name Name of the parameter.
 * @property type Type of the parameter.
 */
public data class ParameterDeclarationResponse(
    public val default: String? = null,
    public val description: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.ParameterDeclarationResponse):
            ParameterDeclarationResponse = ParameterDeclarationResponse(
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
