@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The user assigned managed identity to use when accessing a resource.
 * @property userAssignedIdentity The user assigned managed identity's resource identifier to use when accessing a resource.
 */
public data class ResourceIdentityResponse(
    public val userAssignedIdentity: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.ResourceIdentityResponse):
            ResourceIdentityResponse = ResourceIdentityResponse(
            userAssignedIdentity = javaType.userAssignedIdentity(),
        )
    }
}
