@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details about the associated storage account.
 * @property id The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
 * @property identity A managed identity that Video Analyzer will use to access the storage account.
 * @property status The current status of the storage account mapping.
 */
public data class StorageAccountResponse(
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.StorageAccountResponse):
            StorageAccountResponse = StorageAccountResponse(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
        )
    }
}
