@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Optional properties to be used in case a new video resource needs to be created on the service. These will not take effect if the video already exists.
 * @property description Optional description provided by the user. Value can be up to 2048 characters long.
 * @property retentionPeriod Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "P1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
 * @property segmentLength Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
 * @property title Optional title provided by the user. Value can be up to 256 characters long.
 */
public data class VideoCreationPropertiesResponse(
    public val description: String? = null,
    public val retentionPeriod: String? = null,
    public val segmentLength: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoCreationPropertiesResponse):
            VideoCreationPropertiesResponse = VideoCreationPropertiesResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            retentionPeriod = javaType.retentionPeriod().map({ args0 -> args0 }).orElse(null),
            segmentLength = javaType.segmentLength().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
