@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoindexer.kotlin

import com.pulumi.azurenative.videoindexer.VideoindexerFunctions.getAccountPlain
import com.pulumi.azurenative.videoindexer.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.videoindexer.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.videoindexer.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.videoindexer.kotlin.outputs.GetAccountResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object VideoindexerFunctions {
    /**
     * Gets the properties of an Azure Video Indexer account.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2024-01-01.
     * @param argument null
     * @return An Azure Video Indexer account.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        toKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the Azure Video Indexer account.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Video Indexer account.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;videoindexer&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return An Azure Video Indexer account.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAccountPlain(builtArgument.toJava()).await())
    }
}
