@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin

import com.pulumi.azurenative.virtualmachineimages.TriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a trigger that can invoke an image template build.
 * Azure REST API version: 2022-07-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update a source image type trigger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trigger = new AzureNative.VirtualMachineImages.Trigger("trigger", new()
 *     {
 *         ImageTemplateName = "myImageTemplate",
 *         Kind = "SourceImage",
 *         ResourceGroupName = "myResourceGroup",
 *         TriggerName = "source",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/virtualmachineimages/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := virtualmachineimages.NewTrigger(ctx, "trigger", &virtualmachineimages.TriggerArgs{
 * 			ImageTemplateName: pulumi.String("myImageTemplate"),
 * 			Kind:              pulumi.String("SourceImage"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			TriggerName:       pulumi.String("source"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.virtualmachineimages.Trigger;
 * import com.pulumi.azurenative.virtualmachineimages.TriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trigger = new Trigger("trigger", TriggerArgs.builder()
 *             .imageTemplateName("myImageTemplate")
 *             .kind("SourceImage")
 *             .resourceGroupName("myResourceGroup")
 *             .triggerName("source")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:virtualmachineimages:Trigger source /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}/triggers/{triggerName}
 * ```
 * @property imageTemplateName The name of the image Template
 * @property kind The kind of trigger.
 * @property resourceGroupName The name of the resource group.
 * @property triggerName The name of the trigger
 */
public data class TriggerArgs(
    public val imageTemplateName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val triggerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.TriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.TriggerArgs =
        com.pulumi.azurenative.virtualmachineimages.TriggerArgs.builder()
            .imageTemplateName(imageTemplateName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .triggerName(triggerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerArgs].
 */
@PulumiTagMarker
public class TriggerArgsBuilder internal constructor() {
    private var imageTemplateName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var triggerName: Output<String>? = null

    /**
     * @param value The name of the image Template
     */
    @JvmName("cdnqgynaokupkued")
    public suspend fun imageTemplateName(`value`: Output<String>) {
        this.imageTemplateName = value
    }

    /**
     * @param value The kind of trigger.
     */
    @JvmName("bvyfdrhiygcubsaq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rciiepvmdwvnalng")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the trigger
     */
    @JvmName("gflgtluvdqyjdwjk")
    public suspend fun triggerName(`value`: Output<String>) {
        this.triggerName = value
    }

    /**
     * @param value The name of the image Template
     */
    @JvmName("kyfkrxtddolrgtmo")
    public suspend fun imageTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTemplateName = mapped
    }

    /**
     * @param value The kind of trigger.
     */
    @JvmName("ywqiiyliafnhembl")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vrtyognsoskoisgr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the trigger
     */
    @JvmName("xjncxivvodqnumdb")
    public suspend fun triggerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerName = mapped
    }

    internal fun build(): TriggerArgs = TriggerArgs(
        imageTemplateName = imageTemplateName,
        kind = kind,
        resourceGroupName = resourceGroupName,
        triggerName = triggerName,
    )
}
