@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin

import com.pulumi.azurenative.virtualmachineimages.VirtualmachineimagesFunctions.getTriggerPlain
import com.pulumi.azurenative.virtualmachineimages.VirtualmachineimagesFunctions.getVirtualMachineImageTemplatePlain
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.GetTriggerPlainArgs
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.GetTriggerPlainArgsBuilder
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.GetVirtualMachineImageTemplatePlainArgs
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.GetVirtualMachineImageTemplatePlainArgsBuilder
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.GetTriggerResult
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.GetVirtualMachineImageTemplateResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.GetTriggerResult.Companion.toKotlin as getTriggerResultToKotlin
import com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.GetVirtualMachineImageTemplateResult.Companion.toKotlin as getVirtualMachineImageTemplateResultToKotlin

public object VirtualmachineimagesFunctions {
    /**
     * Get the specified trigger for the specified image template resource
     * Azure REST API version: 2022-07-01.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return Represents a trigger that can invoke an image template build.
     */
    public suspend fun getTrigger(argument: GetTriggerPlainArgs): GetTriggerResult =
        getTriggerResultToKotlin(getTriggerPlain(argument.toJava()).await())

    /**
     * @see [getTrigger].
     * @param imageTemplateName The name of the image Template
     * @param resourceGroupName The name of the resource group.
     * @param triggerName The name of the trigger
     * @return Represents a trigger that can invoke an image template build.
     */
    public suspend fun getTrigger(
        imageTemplateName: String,
        resourceGroupName: String,
        triggerName: String,
    ): GetTriggerResult {
        val argument = GetTriggerPlainArgs(
            imageTemplateName = imageTemplateName,
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
        )
        return getTriggerResultToKotlin(getTriggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrigger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;virtualmachineimages&#46;kotlin&#46;inputs&#46;GetTriggerPlainArgs].
     * @return Represents a trigger that can invoke an image template build.
     */
    public suspend fun getTrigger(argument: suspend GetTriggerPlainArgsBuilder.() -> Unit):
        GetTriggerResult {
        val builder = GetTriggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTriggerResultToKotlin(getTriggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a virtual machine image template
     * Azure REST API version: 2022-07-01.
     * Other available API versions: 2018-02-01-preview, 2019-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
     */
    public suspend
    fun getVirtualMachineImageTemplate(argument: GetVirtualMachineImageTemplatePlainArgs):
        GetVirtualMachineImageTemplateResult =
        getVirtualMachineImageTemplateResultToKotlin(getVirtualMachineImageTemplatePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachineImageTemplate].
     * @param imageTemplateName The name of the image Template
     * @param resourceGroupName The name of the resource group.
     * @return Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
     */
    public suspend fun getVirtualMachineImageTemplate(
        imageTemplateName: String,
        resourceGroupName: String,
    ): GetVirtualMachineImageTemplateResult {
        val argument = GetVirtualMachineImageTemplatePlainArgs(
            imageTemplateName = imageTemplateName,
            resourceGroupName = resourceGroupName,
        )
        return getVirtualMachineImageTemplateResultToKotlin(getVirtualMachineImageTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachineImageTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;virtualmachineimages&#46;kotlin&#46;inputs&#46;GetVirtualMachineImageTemplatePlainArgs].
     * @return Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
     */
    public suspend
    fun getVirtualMachineImageTemplate(argument: suspend GetVirtualMachineImageTemplatePlainArgsBuilder.() -> Unit):
        GetVirtualMachineImageTemplateResult {
        val builder = GetVirtualMachineImageTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineImageTemplateResultToKotlin(getVirtualMachineImageTemplatePlain(builtArgument.toJava()).await())
    }
}
