@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.GetTriggerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageTemplateName The name of the image Template
 * @property resourceGroupName The name of the resource group.
 * @property triggerName The name of the trigger
 */
public data class GetTriggerPlainArgs(
    public val imageTemplateName: String,
    public val resourceGroupName: String,
    public val triggerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.GetTriggerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.GetTriggerPlainArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.GetTriggerPlainArgs.builder()
            .imageTemplateName(imageTemplateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTriggerPlainArgs].
 */
@PulumiTagMarker
public class GetTriggerPlainArgsBuilder internal constructor() {
    private var imageTemplateName: String? = null

    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    /**
     * @param value The name of the image Template
     */
    @JvmName("lfjtwktojmrechlg")
    public suspend fun imageTemplateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.imageTemplateName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wrnhuxkwtggqafjk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the trigger
     */
    @JvmName("saqmgqlsalpupejr")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    internal fun build(): GetTriggerPlainArgs = GetTriggerPlainArgs(
        imageTemplateName = imageTemplateName ?: throw PulumiNullFieldException("imageTemplateName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
    )
}
