@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePlatformImageSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an image source from [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property offer Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property planInfo Optional configuration of purchase plan for platform image.
 * @property publisher Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property sku Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property type Specifies the type of source image you want to start with.
 * Expected value is 'PlatformImage'.
 * @property version Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). If 'latest' is specified here, the version is evaluated when the image build takes place, not when the template is submitted.
 */
public data class ImageTemplatePlatformImageSourceArgs(
    public val offer: Output<String>? = null,
    public val planInfo: Output<PlatformImagePurchasePlanArgs>? = null,
    public val publisher: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePlatformImageSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePlatformImageSourceArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePlatformImageSourceArgs.builder()
            .offer(offer?.applyValue({ args0 -> args0 }))
            .planInfo(planInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplatePlatformImageSourceArgs].
 */
@PulumiTagMarker
public class ImageTemplatePlatformImageSourceArgsBuilder internal constructor() {
    private var offer: Output<String>? = null

    private var planInfo: Output<PlatformImagePurchasePlanArgs>? = null

    private var publisher: Output<String>? = null

    private var sku: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
     */
    @JvmName("wdtegmqcdxjwquut")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value Optional configuration of purchase plan for platform image.
     */
    @JvmName("pcuuvlboqjquocdp")
    public suspend fun planInfo(`value`: Output<PlatformImagePurchasePlanArgs>) {
        this.planInfo = value
    }

    /**
     * @param value Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
     */
    @JvmName("nmpghccjrhrujena")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
     */
    @JvmName("yyxutrmvpchudldk")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Specifies the type of source image you want to start with.
     * Expected value is 'PlatformImage'.
     */
    @JvmName("gbocpopnrhfyhapu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). If 'latest' is specified here, the version is evaluated when the image build takes place, not when the template is submitted.
     */
    @JvmName("wixggyuuptwppfcu")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
     */
    @JvmName("qppomrkpdxqfwtjd")
    public suspend fun offer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value Optional configuration of purchase plan for platform image.
     */
    @JvmName("ttouejqkufgnxeeu")
    public suspend fun planInfo(`value`: PlatformImagePurchasePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planInfo = mapped
    }

    /**
     * @param argument Optional configuration of purchase plan for platform image.
     */
    @JvmName("sonqliwyrbqvumui")
    public suspend fun planInfo(argument: suspend PlatformImagePurchasePlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlatformImagePurchasePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.planInfo = mapped
    }

    /**
     * @param value Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
     */
    @JvmName("qkqhypblwjhwvvle")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
     */
    @JvmName("kugdhlsaebkxdpuj")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Specifies the type of source image you want to start with.
     * Expected value is 'PlatformImage'.
     */
    @JvmName("midccouiftxnrbkn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). If 'latest' is specified here, the version is evaluated when the image build takes place, not when the template is submitted.
     */
    @JvmName("gklaphwbolarjsqo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ImageTemplatePlatformImageSourceArgs = ImageTemplatePlatformImageSourceArgs(
        offer = offer,
        planInfo = planInfo,
        publisher = publisher,
        sku = sku,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
