@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesValidateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration options and list of validations to be performed on the resulting image.
 * @property continueDistributeOnFailure If validation fails and this field is set to false, output image(s) will not be distributed. This is the default behavior. If validation fails and this field is set to true, output image(s) will still be distributed. Please use this option with caution as it may result in bad images being distributed for use. In either case (true or false), the end to end image run will be reported as having failed in case of a validation failure. [Note: This field has no effect if validation succeeds&#46;]
 * @property inVMValidations List of validations to be performed.
 * @property sourceValidationOnly If this field is set to true, the image specified in the 'source' section will directly be validated. No separate build will be run to generate and then validate a customized image.
 */
public data class ImageTemplatePropertiesValidateArgs(
    public val continueDistributeOnFailure: Output<Boolean>? = null,
    public val inVMValidations: Output<List<Any>>? = null,
    public val sourceValidationOnly: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesValidateArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesValidateArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesValidateArgs.builder()
            .continueDistributeOnFailure(continueDistributeOnFailure?.applyValue({ args0 -> args0 }))
            .inVMValidations(inVMValidations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceValidationOnly(sourceValidationOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplatePropertiesValidateArgs].
 */
@PulumiTagMarker
public class ImageTemplatePropertiesValidateArgsBuilder internal constructor() {
    private var continueDistributeOnFailure: Output<Boolean>? = null

    private var inVMValidations: Output<List<Any>>? = null

    private var sourceValidationOnly: Output<Boolean>? = null

    /**
     * @param value If validation fails and this field is set to false, output image(s) will not be distributed. This is the default behavior. If validation fails and this field is set to true, output image(s) will still be distributed. Please use this option with caution as it may result in bad images being distributed for use. In either case (true or false), the end to end image run will be reported as having failed in case of a validation failure. [Note: This field has no effect if validation succeeds&#46;]
     */
    @JvmName("okjkiehnwlxunxlp")
    public suspend fun continueDistributeOnFailure(`value`: Output<Boolean>) {
        this.continueDistributeOnFailure = value
    }

    /**
     * @param value List of validations to be performed.
     */
    @JvmName("kialbjyqhcvdhjwn")
    public suspend fun inVMValidations(`value`: Output<List<Any>>) {
        this.inVMValidations = value
    }

    @JvmName("jpenskdtxomldvxk")
    public suspend fun inVMValidations(vararg values: Output<Any>) {
        this.inVMValidations = Output.all(values.asList())
    }

    /**
     * @param values List of validations to be performed.
     */
    @JvmName("wsaeaevwwfpivwqf")
    public suspend fun inVMValidations(values: List<Output<Any>>) {
        this.inVMValidations = Output.all(values)
    }

    /**
     * @param value If this field is set to true, the image specified in the 'source' section will directly be validated. No separate build will be run to generate and then validate a customized image.
     */
    @JvmName("wykokxofogvxwwcm")
    public suspend fun sourceValidationOnly(`value`: Output<Boolean>) {
        this.sourceValidationOnly = value
    }

    /**
     * @param value If validation fails and this field is set to false, output image(s) will not be distributed. This is the default behavior. If validation fails and this field is set to true, output image(s) will still be distributed. Please use this option with caution as it may result in bad images being distributed for use. In either case (true or false), the end to end image run will be reported as having failed in case of a validation failure. [Note: This field has no effect if validation succeeds&#46;]
     */
    @JvmName("srmyjfjjggquwqor")
    public suspend fun continueDistributeOnFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continueDistributeOnFailure = mapped
    }

    /**
     * @param value List of validations to be performed.
     */
    @JvmName("rufeettayfeteqvn")
    public suspend fun inVMValidations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inVMValidations = mapped
    }

    /**
     * @param values List of validations to be performed.
     */
    @JvmName("qhkglcwvycuvnysv")
    public suspend fun inVMValidations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inVMValidations = mapped
    }

    /**
     * @param value If this field is set to true, the image specified in the 'source' section will directly be validated. No separate build will be run to generate and then validate a customized image.
     */
    @JvmName("miwnbuqwqthakrcn")
    public suspend fun sourceValidationOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceValidationOnly = mapped
    }

    internal fun build(): ImageTemplatePropertiesValidateArgs = ImageTemplatePropertiesValidateArgs(
        continueDistributeOnFailure = continueDistributeOnFailure,
        inVMValidations = inVMValidations,
        sourceValidationOnly = sourceValidationOnly,
    )
}
