@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageDistributorArgs.builder
import com.pulumi.azurenative.virtualmachineimages.kotlin.enums.SharedImageStorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Distribute via Azure Compute Gallery.
 * @property artifactTags Tags that will be applied to the artifact once it has been created/updated by the distributor.
 * @property excludeFromLatest Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
 * @property galleryImageId Resource Id of the Azure Compute Gallery image
 * @property replicationRegions [Deprecated] A list of regions that the image will be replicated to. This list can be specified only if targetRegions is not specified. This field is deprecated - use targetRegions instead.
 * @property runOutputName The name to be used for the associated RunOutput.
 * @property storageAccountType [Deprecated] Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS). This field can be specified only if replicationRegions is specified. This field is deprecated - use targetRegions instead.
 * @property targetRegions The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
 * @property type Type of distribution.
 * Expected value is 'SharedImage'.
 * @property versioning Describes how to generate new x.y.z version number for distribution.
 */
public data class ImageTemplateSharedImageDistributorArgs(
    public val artifactTags: Output<Map<String, String>>? = null,
    public val excludeFromLatest: Output<Boolean>? = null,
    public val galleryImageId: Output<String>,
    public val replicationRegions: Output<List<String>>? = null,
    public val runOutputName: Output<String>,
    public val storageAccountType: Output<Either<String, SharedImageStorageAccountType>>? = null,
    public val targetRegions: Output<List<TargetRegionArgs>>? = null,
    public val type: Output<String>,
    public val versioning:
    Output<Either<DistributeVersionerLatestArgs, DistributeVersionerSourceArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageDistributorArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageDistributorArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateSharedImageDistributorArgs.builder()
            .artifactTags(
                artifactTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .excludeFromLatest(excludeFromLatest?.applyValue({ args0 -> args0 }))
            .galleryImageId(galleryImageId.applyValue({ args0 -> args0 }))
            .replicationRegions(replicationRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .runOutputName(runOutputName.applyValue({ args0 -> args0 }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .targetRegions(
                targetRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .versioning(
                versioning?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ImageTemplateSharedImageDistributorArgs].
 */
@PulumiTagMarker
public class ImageTemplateSharedImageDistributorArgsBuilder internal constructor() {
    private var artifactTags: Output<Map<String, String>>? = null

    private var excludeFromLatest: Output<Boolean>? = null

    private var galleryImageId: Output<String>? = null

    private var replicationRegions: Output<List<String>>? = null

    private var runOutputName: Output<String>? = null

    private var storageAccountType: Output<Either<String, SharedImageStorageAccountType>>? = null

    private var targetRegions: Output<List<TargetRegionArgs>>? = null

    private var type: Output<String>? = null

    private var versioning:
        Output<Either<DistributeVersionerLatestArgs, DistributeVersionerSourceArgs>>? = null

    /**
     * @param value Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("omnlnkeiasqcuplg")
    public suspend fun artifactTags(`value`: Output<Map<String, String>>) {
        this.artifactTags = value
    }

    /**
     * @param value Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
     */
    @JvmName("odkanyluhkuoumvn")
    public suspend fun excludeFromLatest(`value`: Output<Boolean>) {
        this.excludeFromLatest = value
    }

    /**
     * @param value Resource Id of the Azure Compute Gallery image
     */
    @JvmName("vustxpnfchkyhnos")
    public suspend fun galleryImageId(`value`: Output<String>) {
        this.galleryImageId = value
    }

    /**
     * @param value [Deprecated] A list of regions that the image will be replicated to. This list can be specified only if targetRegions is not specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("uioraiohiospyuio")
    public suspend fun replicationRegions(`value`: Output<List<String>>) {
        this.replicationRegions = value
    }

    @JvmName("fsrsxybpmahskkwo")
    public suspend fun replicationRegions(vararg values: Output<String>) {
        this.replicationRegions = Output.all(values.asList())
    }

    /**
     * @param values [Deprecated] A list of regions that the image will be replicated to. This list can be specified only if targetRegions is not specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("nlxerwrmnofjwhhs")
    public suspend fun replicationRegions(values: List<Output<String>>) {
        this.replicationRegions = Output.all(values)
    }

    /**
     * @param value The name to be used for the associated RunOutput.
     */
    @JvmName("qxfkpdfdnrdaktov")
    public suspend fun runOutputName(`value`: Output<String>) {
        this.runOutputName = value
    }

    /**
     * @param value [Deprecated] Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS). This field can be specified only if replicationRegions is specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("dnodnvlxaosvphlr")
    public suspend
    fun storageAccountType(`value`: Output<Either<String, SharedImageStorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("ixmqxaetsccoqfof")
    public suspend fun targetRegions(`value`: Output<List<TargetRegionArgs>>) {
        this.targetRegions = value
    }

    @JvmName("fgfedikdmdipypuy")
    public suspend fun targetRegions(vararg values: Output<TargetRegionArgs>) {
        this.targetRegions = Output.all(values.asList())
    }

    /**
     * @param values The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("foophviexurxctpu")
    public suspend fun targetRegions(values: List<Output<TargetRegionArgs>>) {
        this.targetRegions = Output.all(values)
    }

    /**
     * @param value Type of distribution.
     * Expected value is 'SharedImage'.
     */
    @JvmName("owcgayonmgiddwvm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Describes how to generate new x.y.z version number for distribution.
     */
    @JvmName("rakchxoqjovtxbbx")
    public suspend
    fun versioning(`value`: Output<Either<DistributeVersionerLatestArgs, DistributeVersionerSourceArgs>>) {
        this.versioning = value
    }

    /**
     * @param value Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("shtokebyvhqaeypk")
    public suspend fun artifactTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactTags = mapped
    }

    /**
     * @param values Tags that will be applied to the artifact once it has been created/updated by the distributor.
     */
    @JvmName("mxrrqwjammdrnqda")
    public fun artifactTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactTags = mapped
    }

    /**
     * @param value Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
     */
    @JvmName("vdfcnrusiujmxhca")
    public suspend fun excludeFromLatest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeFromLatest = mapped
    }

    /**
     * @param value Resource Id of the Azure Compute Gallery image
     */
    @JvmName("ndgjesotbbdtoife")
    public suspend fun galleryImageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.galleryImageId = mapped
    }

    /**
     * @param value [Deprecated] A list of regions that the image will be replicated to. This list can be specified only if targetRegions is not specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("flfvvbqblesjhdoa")
    public suspend fun replicationRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationRegions = mapped
    }

    /**
     * @param values [Deprecated] A list of regions that the image will be replicated to. This list can be specified only if targetRegions is not specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("xutsixgwsntbsdnv")
    public suspend fun replicationRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRegions = mapped
    }

    /**
     * @param value The name to be used for the associated RunOutput.
     */
    @JvmName("srwbhweoqmgnbgko")
    public suspend fun runOutputName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runOutputName = mapped
    }

    /**
     * @param value [Deprecated] Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS). This field can be specified only if replicationRegions is specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("webdtvcrhxnakifu")
    public suspend fun storageAccountType(`value`: Either<String, SharedImageStorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value [Deprecated] Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS). This field can be specified only if replicationRegions is specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("rgwvytyncvyuvyup")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SharedImageStorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value [Deprecated] Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS). This field can be specified only if replicationRegions is specified. This field is deprecated - use targetRegions instead.
     */
    @JvmName("xnqtylfveqykkwlh")
    public fun storageAccountType(`value`: SharedImageStorageAccountType) {
        val toBeMapped = Either.ofRight<String, SharedImageStorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("eiqgtgvjeggnbddv")
    public suspend fun targetRegions(`value`: List<TargetRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("qeraefgqlprbyjmo")
    public suspend fun targetRegions(argument: List<suspend TargetRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("xxliioxgswxwmvaq")
    public suspend fun targetRegions(vararg argument: suspend TargetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("ogxmqxfbujrccger")
    public suspend fun targetRegions(argument: suspend TargetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetRegionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param values The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
     */
    @JvmName("xncypstrutracjap")
    public suspend fun targetRegions(vararg values: TargetRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRegions = mapped
    }

    /**
     * @param value Type of distribution.
     * Expected value is 'SharedImage'.
     */
    @JvmName("lxriaqfxckmxxktu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Describes how to generate new x.y.z version number for distribution.
     */
    @JvmName("bwkyycdfujcasmqq")
    public suspend
    fun versioning(`value`: Either<DistributeVersionerLatestArgs, DistributeVersionerSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioning = mapped
    }

    /**
     * @param value Describes how to generate new x.y.z version number for distribution.
     */
    @JvmName("yubmfjbmqdlxdxss")
    public fun versioning(`value`: DistributeVersionerLatestArgs) {
        val toBeMapped = Either.ofLeft<DistributeVersionerLatestArgs,
            DistributeVersionerSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versioning = mapped
    }

    /**
     * @param value Describes how to generate new x.y.z version number for distribution.
     */
    @JvmName("naynfavqctichjkb")
    public fun versioning(`value`: DistributeVersionerSourceArgs) {
        val toBeMapped = Either.ofRight<DistributeVersionerLatestArgs,
            DistributeVersionerSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versioning = mapped
    }

    internal fun build(): ImageTemplateSharedImageDistributorArgs =
        ImageTemplateSharedImageDistributorArgs(
            artifactTags = artifactTags,
            excludeFromLatest = excludeFromLatest,
            galleryImageId = galleryImageId ?: throw PulumiNullFieldException("galleryImageId"),
            replicationRegions = replicationRegions,
            runOutputName = runOutputName ?: throw PulumiNullFieldException("runOutputName"),
            storageAccountType = storageAccountType,
            targetRegions = targetRegions,
            type = type ?: throw PulumiNullFieldException("type"),
            versioning = versioning,
        )
}
