@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellValidatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Runs the specified shell script during the validation phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
 * @property inline Array of shell commands to execute
 * @property name Friendly Name to provide context on what this validation step does
 * @property scriptUri URI of the shell script to be run for validation. It can be a github link, Azure Storage URI, etc
 * @property sha256Checksum SHA256 checksum of the shell script provided in the scriptUri field
 * @property type The type of validation you want to use on the Image. For example, "Shell" can be shell validation
 * Expected value is 'Shell'.
 */
public data class ImageTemplateShellValidatorArgs(
    public val `inline`: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val scriptUri: Output<String>? = null,
    public val sha256Checksum: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellValidatorArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellValidatorArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellValidatorArgs.builder()
            .`inline`(`inline`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scriptUri(scriptUri?.applyValue({ args0 -> args0 }))
            .sha256Checksum(sha256Checksum?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateShellValidatorArgs].
 */
@PulumiTagMarker
public class ImageTemplateShellValidatorArgsBuilder internal constructor() {
    private var `inline`: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var scriptUri: Output<String>? = null

    private var sha256Checksum: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Array of shell commands to execute
     */
    @JvmName("tommggqnyvjyxmrc")
    public suspend fun `inline`(`value`: Output<List<String>>) {
        this.`inline` = value
    }

    @JvmName("upxslcvjwacwekiy")
    public suspend fun `inline`(vararg values: Output<String>) {
        this.`inline` = Output.all(values.asList())
    }

    /**
     * @param values Array of shell commands to execute
     */
    @JvmName("wwsccnwtsgybnlop")
    public suspend fun `inline`(values: List<Output<String>>) {
        this.`inline` = Output.all(values)
    }

    /**
     * @param value Friendly Name to provide context on what this validation step does
     */
    @JvmName("udekorrrajulnsye")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URI of the shell script to be run for validation. It can be a github link, Azure Storage URI, etc
     */
    @JvmName("sqihadmjwyypoxgb")
    public suspend fun scriptUri(`value`: Output<String>) {
        this.scriptUri = value
    }

    /**
     * @param value SHA256 checksum of the shell script provided in the scriptUri field
     */
    @JvmName("avmgsqvadocecuat")
    public suspend fun sha256Checksum(`value`: Output<String>) {
        this.sha256Checksum = value
    }

    /**
     * @param value The type of validation you want to use on the Image. For example, "Shell" can be shell validation
     * Expected value is 'Shell'.
     */
    @JvmName("ayhvbsejwhddatlr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Array of shell commands to execute
     */
    @JvmName("vavnrsomnmixafko")
    public suspend fun `inline`(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`inline` = mapped
    }

    /**
     * @param values Array of shell commands to execute
     */
    @JvmName("gxjhaisyrwuxmtch")
    public suspend fun `inline`(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`inline` = mapped
    }

    /**
     * @param value Friendly Name to provide context on what this validation step does
     */
    @JvmName("jbkvijxfbgiogirm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URI of the shell script to be run for validation. It can be a github link, Azure Storage URI, etc
     */
    @JvmName("liqsblronqxvbnmc")
    public suspend fun scriptUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUri = mapped
    }

    /**
     * @param value SHA256 checksum of the shell script provided in the scriptUri field
     */
    @JvmName("viswmugsibnulgjy")
    public suspend fun sha256Checksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sha256Checksum = mapped
    }

    /**
     * @param value The type of validation you want to use on the Image. For example, "Shell" can be shell validation
     * Expected value is 'Shell'.
     */
    @JvmName("esthxtscerdfjsnw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateShellValidatorArgs = ImageTemplateShellValidatorArgs(
        `inline` = `inline`,
        name = name,
        scriptUri = scriptUri,
        sha256Checksum = sha256Checksum,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
