@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.VirtualNetworkConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network configuration.
 * @property proxyVmSize Size of the proxy virtual machine used to pass traffic to the build VM and validation VM. Omit or specify empty string to use the default (Standard_A1_v2).
 * @property subnetId Resource id of a pre-existing subnet.
 */
public data class VirtualNetworkConfigArgs(
    public val proxyVmSize: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.VirtualNetworkConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.VirtualNetworkConfigArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.VirtualNetworkConfigArgs.builder()
            .proxyVmSize(proxyVmSize?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkConfigArgs].
 */
@PulumiTagMarker
public class VirtualNetworkConfigArgsBuilder internal constructor() {
    private var proxyVmSize: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Size of the proxy virtual machine used to pass traffic to the build VM and validation VM. Omit or specify empty string to use the default (Standard_A1_v2).
     */
    @JvmName("hhlicumglgduqecq")
    public suspend fun proxyVmSize(`value`: Output<String>) {
        this.proxyVmSize = value
    }

    /**
     * @param value Resource id of a pre-existing subnet.
     */
    @JvmName("alpnhhsyhiuwowsa")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Size of the proxy virtual machine used to pass traffic to the build VM and validation VM. Omit or specify empty string to use the default (Standard_A1_v2).
     */
    @JvmName("toagyqbbatoqknuq")
    public suspend fun proxyVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyVmSize = mapped
    }

    /**
     * @param value Resource id of a pre-existing subnet.
     */
    @JvmName("gpivxyewdmknycra")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): VirtualNetworkConfigArgs = VirtualNetworkConfigArgs(
        proxyVmSize = proxyVmSize,
        subnetId = subnetId,
    )
}
