@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
 * @property buildTimeoutInMinutes Maximum duration to wait while building the image template (includes all customizations, optimization, validations, and distributions). Omit or specify 0 to use the default (4 hours).
 * @property customize Specifies the properties used to describe the customization steps of the image, like Image source etc
 * @property distribute The distribution targets where the image output needs to go to.
 * @property exactStagingResourceGroup The staging resource group id in the same subscription as the image template that will be used to build the image. This read-only field differs from 'stagingResourceGroup' only if the value specified in the 'stagingResourceGroup' field is empty.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the image template, if configured.
 * @property lastRunStatus State of 'run' that is currently executing or was last executed.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property optimize Specifies optimization to be performed on image.
 * @property provisioningError Provisioning error, if any
 * @property provisioningState Provisioning state of the resource
 * @property source Specifies the properties used to describe the source image.
 * @property stagingResourceGroup The staging resource group id in the same subscription as the image template that will be used to build the image. If this field is empty, a resource group with a random name will be created. If the resource group specified in this field doesn't exist, it will be created with the same name. If the resource group specified exists, it must be empty and in the same region as the image template. The resource group created will be deleted during template deletion if this field is empty or the resource group specified doesn't exist, but if the resource group specified exists the resources created in the resource group will be deleted during template deletion and the resource group itself will remain.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property validate Configuration options and list of validations to be performed on the resulting image.
 * @property vmProfile Describes how virtual machine is set up to build images
 */
public data class GetVirtualMachineImageTemplateResult(
    public val buildTimeoutInMinutes: Int? = null,
    public val customize: List<Any>? = null,
    public val distribute: List<Any>,
    public val exactStagingResourceGroup: String,
    public val id: String,
    public val identity: ImageTemplateIdentityResponse,
    public val lastRunStatus: ImageTemplateLastRunStatusResponse,
    public val location: String,
    public val name: String,
    public val optimize: ImageTemplatePropertiesResponseOptimize? = null,
    public val provisioningError: ProvisioningErrorResponse,
    public val provisioningState: String,
    public val source: Any,
    public val stagingResourceGroup: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val validate: ImageTemplatePropertiesResponseValidate? = null,
    public val vmProfile: ImageTemplateVmProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.GetVirtualMachineImageTemplateResult):
            GetVirtualMachineImageTemplateResult = GetVirtualMachineImageTemplateResult(
            buildTimeoutInMinutes = javaType.buildTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            customize = javaType.customize().map({ args0 -> args0 }),
            distribute = javaType.distribute().map({ args0 -> args0 }),
            exactStagingResourceGroup = javaType.exactStagingResourceGroup(),
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateIdentityResponse.Companion.toKotlin(args0)
            }),
            lastRunStatus = javaType.lastRunStatus().let({ args0 ->
                com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateLastRunStatusResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            optimize = javaType.optimize().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseOptimize.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningError = javaType.provisioningError().let({ args0 ->
                com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ProvisioningErrorResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            source = javaType.source(),
            stagingResourceGroup = javaType.stagingResourceGroup().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            validate = javaType.validate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplatePropertiesResponseValidate.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmProfile = javaType.vmProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.ImageTemplateVmProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
