@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an image source that is a managed image in customer subscription. This image must reside in the same subscription and region as the Image Builder template.
 * @property imageId ARM resource id of the managed image in customer subscription
 * @property type Specifies the type of source image you want to start with.
 * Expected value is 'ManagedImage'.
 */
public data class ImageTemplateManagedImageSourceResponse(
    public val imageId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateManagedImageSourceResponse):
            ImageTemplateManagedImageSourceResponse = ImageTemplateManagedImageSourceResponse(
            imageId = javaType.imageId(),
            type = javaType.type(),
        )
    }
}
