@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration options and list of validations to be performed on the resulting image.
 * @property continueDistributeOnFailure If validation fails and this field is set to false, output image(s) will not be distributed. This is the default behavior. If validation fails and this field is set to true, output image(s) will still be distributed. Please use this option with caution as it may result in bad images being distributed for use. In either case (true or false), the end to end image run will be reported as having failed in case of a validation failure. [Note: This field has no effect if validation succeeds&#46;]
 * @property inVMValidations List of validations to be performed.
 * @property sourceValidationOnly If this field is set to true, the image specified in the 'source' section will directly be validated. No separate build will be run to generate and then validate a customized image.
 */
public data class ImageTemplatePropertiesResponseValidate(
    public val continueDistributeOnFailure: Boolean? = null,
    public val inVMValidations: List<Any>? = null,
    public val sourceValidationOnly: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplatePropertiesResponseValidate):
            ImageTemplatePropertiesResponseValidate = ImageTemplatePropertiesResponseValidate(
            continueDistributeOnFailure = javaType.continueDistributeOnFailure().map({ args0 ->
                args0
            }).orElse(null),
            inVMValidations = javaType.inVMValidations().map({ args0 -> args0 }),
            sourceValidationOnly = javaType.sourceValidationOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
