@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Purchase plan configuration for platform image.
 * @property planName Name of the purchase plan.
 * @property planProduct Product of the purchase plan.
 * @property planPublisher Publisher of the purchase plan.
 */
public data class PlatformImagePurchasePlanResponse(
    public val planName: String,
    public val planProduct: String,
    public val planPublisher: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.PlatformImagePurchasePlanResponse):
            PlatformImagePurchasePlanResponse = PlatformImagePurchasePlanResponse(
            planName = javaType.planName(),
            planProduct = javaType.planProduct(),
            planPublisher = javaType.planPublisher(),
        )
    }
}
