@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dedicated cloud service model
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### CreateDedicatedCloudService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedCloudService = new AzureNative.VMwareCloudSimple.DedicatedCloudService("dedicatedCloudService", new()
 *     {
 *         DedicatedCloudServiceName = "myService",
 *         GatewaySubnet = "10.0.0.0",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/vmwarecloudsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vmwarecloudsimple.NewDedicatedCloudService(ctx, "dedicatedCloudService", &vmwarecloudsimple.DedicatedCloudServiceArgs{
 * 			DedicatedCloudServiceName: pulumi.String("myService"),
 * 			GatewaySubnet:             pulumi.String("10.0.0.0"),
 * 			Location:                  pulumi.String("westus"),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudService;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedCloudService = new DedicatedCloudService("dedicatedCloudService", DedicatedCloudServiceArgs.builder()
 *             .dedicatedCloudServiceName("myService")
 *             .gatewaySubnet("10.0.0.0")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:vmwarecloudsimple:DedicatedCloudService myService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VMwareCloudSimple/dedicatedCloudServices/{dedicatedCloudServiceName}
 * ```
 * @property dedicatedCloudServiceName dedicated cloud Service name
 * @property gatewaySubnet gateway Subnet for the account. It will collect the subnet address and always treat it as /28
 * @property location Azure region
 * @property resourceGroupName The name of the resource group
 * @property tags The list of tags
 */
public data class DedicatedCloudServiceArgs(
    public val dedicatedCloudServiceName: Output<String>? = null,
    public val gatewaySubnet: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudServiceArgs =
        com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudServiceArgs.builder()
            .dedicatedCloudServiceName(dedicatedCloudServiceName?.applyValue({ args0 -> args0 }))
            .gatewaySubnet(gatewaySubnet?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DedicatedCloudServiceArgs].
 */
@PulumiTagMarker
public class DedicatedCloudServiceArgsBuilder internal constructor() {
    private var dedicatedCloudServiceName: Output<String>? = null

    private var gatewaySubnet: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value dedicated cloud Service name
     */
    @JvmName("ckgshmrmmxhfnhjk")
    public suspend fun dedicatedCloudServiceName(`value`: Output<String>) {
        this.dedicatedCloudServiceName = value
    }

    /**
     * @param value gateway Subnet for the account. It will collect the subnet address and always treat it as /28
     */
    @JvmName("jlkrhfdhrhcjgntl")
    public suspend fun gatewaySubnet(`value`: Output<String>) {
        this.gatewaySubnet = value
    }

    /**
     * @param value Azure region
     */
    @JvmName("puckwwxpgdolasjg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("clqntdrysqboarfb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of tags
     */
    @JvmName("yagvkixypjgncdaa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value dedicated cloud Service name
     */
    @JvmName("rnbrxsmpxvpkkpgl")
    public suspend fun dedicatedCloudServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedCloudServiceName = mapped
    }

    /**
     * @param value gateway Subnet for the account. It will collect the subnet address and always treat it as /28
     */
    @JvmName("cmauuxqrwsgasgvb")
    public suspend fun gatewaySubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewaySubnet = mapped
    }

    /**
     * @param value Azure region
     */
    @JvmName("vrphfbidbvqjhltw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("eyscqvehhyvpxenq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of tags
     */
    @JvmName("ticrxesoqmpugjrb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags
     */
    @JvmName("icrfovbcpukrbxyt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DedicatedCloudServiceArgs = DedicatedCloudServiceArgs(
        dedicatedCloudServiceName = dedicatedCloudServiceName,
        gatewaySubnet = gatewaySubnet,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
