@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSCustomizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Guest OS Customization properties
 * @property dnsServers List of dns servers to use
 * @property hostName Virtual Machine hostname
 * @property password Password for login
 * @property policyId id of customization policy
 * @property username Username for login
 */
public data class GuestOSCustomizationArgs(
    public val dnsServers: Output<List<String>>? = null,
    public val hostName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSCustomizationArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSCustomizationArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GuestOSCustomizationArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestOSCustomizationArgs].
 */
@PulumiTagMarker
public class GuestOSCustomizationArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    private var hostName: Output<String>? = null

    private var password: Output<String>? = null

    private var policyId: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value List of dns servers to use
     */
    @JvmName("nwopfgjuwrmbqleq")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("yeekwgctdkbfkhoi")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of dns servers to use
     */
    @JvmName("dbrrdncablbpkryl")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Virtual Machine hostname
     */
    @JvmName("evrlyniwrtnyejmi")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Password for login
     */
    @JvmName("dtgqysndycpaesji")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value id of customization policy
     */
    @JvmName("uvyqdqspeiaqvevn")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Username for login
     */
    @JvmName("alxfrqlacgywfavp")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value List of dns servers to use
     */
    @JvmName("oegimagfumfvudvl")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values List of dns servers to use
     */
    @JvmName("yodfbllabdktskgh")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Virtual Machine hostname
     */
    @JvmName("ediavtqxnhyfrlxh")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Password for login
     */
    @JvmName("dokfocbslhpcyaab")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value id of customization policy
     */
    @JvmName("dhcxubhdcvshksvs")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Username for login
     */
    @JvmName("nhuvvatdjoyfdmwl")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GuestOSCustomizationArgs = GuestOSCustomizationArgs(
        dnsServers = dnsServers,
        hostName = hostName,
        password = password,
        policyId = policyId,
        username = username,
    )
}
