@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualDiskArgs.builder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.enums.DiskIndependenceMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual disk model
 * @property controllerId Disk's Controller id
 * @property independenceMode Disk's independence mode type
 * @property totalSize Disk's total size
 * @property virtualDiskId Disk's id
 */
public data class VirtualDiskArgs(
    public val controllerId: Output<String>,
    public val independenceMode: Output<DiskIndependenceMode>,
    public val totalSize: Output<Int>,
    public val virtualDiskId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualDiskArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualDiskArgs.builder()
            .controllerId(controllerId.applyValue({ args0 -> args0 }))
            .independenceMode(independenceMode.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .totalSize(totalSize.applyValue({ args0 -> args0 }))
            .virtualDiskId(virtualDiskId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualDiskArgs].
 */
@PulumiTagMarker
public class VirtualDiskArgsBuilder internal constructor() {
    private var controllerId: Output<String>? = null

    private var independenceMode: Output<DiskIndependenceMode>? = null

    private var totalSize: Output<Int>? = null

    private var virtualDiskId: Output<String>? = null

    /**
     * @param value Disk's Controller id
     */
    @JvmName("libboxkuvtcaowjc")
    public suspend fun controllerId(`value`: Output<String>) {
        this.controllerId = value
    }

    /**
     * @param value Disk's independence mode type
     */
    @JvmName("xdojhbunkkruldtq")
    public suspend fun independenceMode(`value`: Output<DiskIndependenceMode>) {
        this.independenceMode = value
    }

    /**
     * @param value Disk's total size
     */
    @JvmName("hsjdtxsyjgeygbkt")
    public suspend fun totalSize(`value`: Output<Int>) {
        this.totalSize = value
    }

    /**
     * @param value Disk's id
     */
    @JvmName("fmxvqbhqkllhvthk")
    public suspend fun virtualDiskId(`value`: Output<String>) {
        this.virtualDiskId = value
    }

    /**
     * @param value Disk's Controller id
     */
    @JvmName("ycyjabxusordungr")
    public suspend fun controllerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controllerId = mapped
    }

    /**
     * @param value Disk's independence mode type
     */
    @JvmName("gugedypstkiqeofe")
    public suspend fun independenceMode(`value`: DiskIndependenceMode) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.independenceMode = mapped
    }

    /**
     * @param value Disk's total size
     */
    @JvmName("aibpgvcsujxukjvv")
    public suspend fun totalSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.totalSize = mapped
    }

    /**
     * @param value Disk's id
     */
    @JvmName("vxxuumautdwudsrl")
    public suspend fun virtualDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualDiskId = mapped
    }

    internal fun build(): VirtualDiskArgs = VirtualDiskArgs(
        controllerId = controllerId ?: throw PulumiNullFieldException("controllerId"),
        independenceMode = independenceMode ?: throw PulumiNullFieldException("independenceMode"),
        totalSize = totalSize ?: throw PulumiNullFieldException("totalSize"),
        virtualDiskId = virtualDiskId,
    )
}
