@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNicArgs.builder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.enums.NICType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Virtual NIC model
 * @property customization guest OS customization for nic
 * @property ipAddresses NIC ip address
 * @property macAddress NIC MAC address
 * @property network Virtual Network
 * @property nicType NIC type
 * @property powerOnBoot Is NIC powered on/off on boot
 * @property virtualNicId NIC id
 */
public data class VirtualNicArgs(
    public val customization: Output<GuestOSNICCustomizationArgs>? = null,
    public val ipAddresses: Output<List<String>>? = null,
    public val macAddress: Output<String>? = null,
    public val network: Output<VirtualNetworkArgs>,
    public val nicType: Output<NICType>,
    public val powerOnBoot: Output<Boolean>? = null,
    public val virtualNicId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNicArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNicArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNicArgs.builder()
            .customization(customization?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .macAddress(macAddress?.applyValue({ args0 -> args0 }))
            .network(network.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nicType(nicType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .powerOnBoot(powerOnBoot?.applyValue({ args0 -> args0 }))
            .virtualNicId(virtualNicId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNicArgs].
 */
@PulumiTagMarker
public class VirtualNicArgsBuilder internal constructor() {
    private var customization: Output<GuestOSNICCustomizationArgs>? = null

    private var ipAddresses: Output<List<String>>? = null

    private var macAddress: Output<String>? = null

    private var network: Output<VirtualNetworkArgs>? = null

    private var nicType: Output<NICType>? = null

    private var powerOnBoot: Output<Boolean>? = null

    private var virtualNicId: Output<String>? = null

    /**
     * @param value guest OS customization for nic
     */
    @JvmName("jmlgwsoykhsqajwe")
    public suspend fun customization(`value`: Output<GuestOSNICCustomizationArgs>) {
        this.customization = value
    }

    /**
     * @param value NIC ip address
     */
    @JvmName("njnguoxmvvgdmkif")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("kcbwafkhgplajyxt")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values NIC ip address
     */
    @JvmName("seykaddokcjjcgbx")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value NIC MAC address
     */
    @JvmName("qfqjfpiqjougvvff")
    public suspend fun macAddress(`value`: Output<String>) {
        this.macAddress = value
    }

    /**
     * @param value Virtual Network
     */
    @JvmName("dhcaryhmkpspluul")
    public suspend fun network(`value`: Output<VirtualNetworkArgs>) {
        this.network = value
    }

    /**
     * @param value NIC type
     */
    @JvmName("ocxrxvertwuceahl")
    public suspend fun nicType(`value`: Output<NICType>) {
        this.nicType = value
    }

    /**
     * @param value Is NIC powered on/off on boot
     */
    @JvmName("fqyalmqufkorgajp")
    public suspend fun powerOnBoot(`value`: Output<Boolean>) {
        this.powerOnBoot = value
    }

    /**
     * @param value NIC id
     */
    @JvmName("hmfdlsabvrwerjwj")
    public suspend fun virtualNicId(`value`: Output<String>) {
        this.virtualNicId = value
    }

    /**
     * @param value guest OS customization for nic
     */
    @JvmName("dpuqikjgtlyujmqa")
    public suspend fun customization(`value`: GuestOSNICCustomizationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customization = mapped
    }

    /**
     * @param argument guest OS customization for nic
     */
    @JvmName("fdbboqbgasljsjxm")
    public suspend
    fun customization(argument: suspend GuestOSNICCustomizationArgsBuilder.() -> Unit) {
        val toBeMapped = GuestOSNICCustomizationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customization = mapped
    }

    /**
     * @param value NIC ip address
     */
    @JvmName("pdbcmyptopybdgoh")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values NIC ip address
     */
    @JvmName("jhhuatuepyornsnk")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value NIC MAC address
     */
    @JvmName("jnvbndqidvbmhyjt")
    public suspend fun macAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macAddress = mapped
    }

    /**
     * @param value Virtual Network
     */
    @JvmName("ruxpnrqumpyjxmpb")
    public suspend fun network(`value`: VirtualNetworkArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument Virtual Network
     */
    @JvmName("idxfpntwxqwrbdiq")
    public suspend fun network(argument: suspend VirtualNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    /**
     * @param value NIC type
     */
    @JvmName("dgvxelbghheiwqtl")
    public suspend fun nicType(`value`: NICType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicType = mapped
    }

    /**
     * @param value Is NIC powered on/off on boot
     */
    @JvmName("mijunwocelcejaxm")
    public suspend fun powerOnBoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerOnBoot = mapped
    }

    /**
     * @param value NIC id
     */
    @JvmName("goryhcloeuyyrkrk")
    public suspend fun virtualNicId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNicId = mapped
    }

    internal fun build(): VirtualNicArgs = VirtualNicArgs(
        customization = customization,
        ipAddresses = ipAddresses,
        macAddress = macAddress,
        network = network ?: throw PulumiNullFieldException("network"),
        nicType = nicType ?: throw PulumiNullFieldException("nicType"),
        powerOnBoot = powerOnBoot,
        virtualNicId = virtualNicId,
    )
}
