@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin

import com.pulumi.azurenative.voiceservices.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.voiceservices.kotlin.outputs.ServiceRegionPropertiesResponse
import com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.voiceservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.voiceservices.kotlin.outputs.ServiceRegionPropertiesResponse.Companion.toKotlin as serviceRegionPropertiesResponseToKotlin
import com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CommunicationsGateway].
 */
@PulumiTagMarker
public class CommunicationsGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommunicationsGatewayArgs = CommunicationsGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommunicationsGatewayArgsBuilder.() -> Unit) {
        val builder = CommunicationsGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CommunicationsGateway {
        val builtJavaResource =
            com.pulumi.azurenative.voiceservices.CommunicationsGateway(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommunicationsGateway(builtJavaResource)
    }
}

/**
 * A CommunicationsGateway resource
 * Azure REST API version: 2023-04-03. Prior API version in Azure Native 1.x: 2022-12-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### CreateCommunicationsGatewayResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var communicationsGateway = new AzureNative.VoiceServices.CommunicationsGateway("communicationsGateway", new()
 *     {
 *         AutoGeneratedDomainNameLabelScope = "NoReuse",
 *         Codecs = new[]
 *         {
 *             "PCMA",
 *         },
 *         CommunicationsGatewayName = "myname",
 *         Connectivity = "PublicAddress",
 *         E911Type = "Standard",
 *         Location = "useast",
 *         Platforms = new[]
 *         {
 *             "OperatorConnect",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServiceLocations = new[]
 *         {
 *             new AzureNative.VoiceServices.Inputs.ServiceRegionPropertiesArgs
 *             {
 *                 Name = "useast",
 *                 PrimaryRegionProperties = new AzureNative.VoiceServices.Inputs.PrimaryRegionPropertiesArgs
 *                 {
 *                     AllowedMediaSourceAddressPrefixes = new[]
 *                     {
 *                         "10.1.2.0/24",
 *                     },
 *                     AllowedSignalingSourceAddressPrefixes = new[]
 *                     {
 *                         "10.1.1.0/24",
 *                     },
 *                     OperatorAddresses = new[]
 *                     {
 *                         "198.51.100.1",
 *                     },
 *                 },
 *             },
 *             new AzureNative.VoiceServices.Inputs.ServiceRegionPropertiesArgs
 *             {
 *                 Name = "useast2",
 *                 PrimaryRegionProperties = new AzureNative.VoiceServices.Inputs.PrimaryRegionPropertiesArgs
 *                 {
 *                     AllowedMediaSourceAddressPrefixes = new[]
 *                     {
 *                         "10.2.2.0/24",
 *                     },
 *                     AllowedSignalingSourceAddressPrefixes = new[]
 *                     {
 *                         "10.2.1.0/24",
 *                     },
 *                     OperatorAddresses = new[]
 *                     {
 *                         "198.51.100.2",
 *                     },
 *                 },
 *             },
 *         },
 *         TeamsVoicemailPilotNumber = "1234567890",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/voiceservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := voiceservices.NewCommunicationsGateway(ctx, "communicationsGateway", &voiceservices.CommunicationsGatewayArgs{
 * 			AutoGeneratedDomainNameLabelScope: pulumi.String("NoReuse"),
 * 			Codecs: pulumi.StringArray{
 * 				pulumi.String("PCMA"),
 * 			},
 * 			CommunicationsGatewayName: pulumi.String("myname"),
 * 			Connectivity:              pulumi.String("PublicAddress"),
 * 			E911Type:                  pulumi.String("Standard"),
 * 			Location:                  pulumi.String("useast"),
 * 			Platforms: pulumi.StringArray{
 * 				pulumi.String("OperatorConnect"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServiceLocations: []voiceservices.ServiceRegionPropertiesArgs{
 * 				{
 * 					Name: pulumi.String("useast"),
 * 					PrimaryRegionProperties: {
 * 						AllowedMediaSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.1.2.0/24"),
 * 						},
 * 						AllowedSignalingSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.1.1.0/24"),
 * 						},
 * 						OperatorAddresses: pulumi.StringArray{
 * 							pulumi.String("198.51.100.1"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					Name: pulumi.String("useast2"),
 * 					PrimaryRegionProperties: {
 * 						AllowedMediaSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.2.2.0/24"),
 * 						},
 * 						AllowedSignalingSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.2.1.0/24"),
 * 						},
 * 						OperatorAddresses: pulumi.StringArray{
 * 							pulumi.String("198.51.100.2"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			TeamsVoicemailPilotNumber: pulumi.String("1234567890"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.voiceservices.CommunicationsGateway;
 * import com.pulumi.azurenative.voiceservices.CommunicationsGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var communicationsGateway = new CommunicationsGateway("communicationsGateway", CommunicationsGatewayArgs.builder()
 *             .autoGeneratedDomainNameLabelScope("NoReuse")
 *             .codecs("PCMA")
 *             .communicationsGatewayName("myname")
 *             .connectivity("PublicAddress")
 *             .e911Type("Standard")
 *             .location("useast")
 *             .platforms("OperatorConnect")
 *             .resourceGroupName("testrg")
 *             .serviceLocations(
 *                 Map.ofEntries(
 *                     Map.entry("name", "useast"),
 *                     Map.entry("primaryRegionProperties", Map.ofEntries(
 *                         Map.entry("allowedMediaSourceAddressPrefixes", "10.1.2.0/24"),
 *                         Map.entry("allowedSignalingSourceAddressPrefixes", "10.1.1.0/24"),
 *                         Map.entry("operatorAddresses", "198.51.100.1")
 *                     ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "useast2"),
 *                     Map.entry("primaryRegionProperties", Map.ofEntries(
 *                         Map.entry("allowedMediaSourceAddressPrefixes", "10.2.2.0/24"),
 *                         Map.entry("allowedSignalingSourceAddressPrefixes", "10.2.1.0/24"),
 *                         Map.entry("operatorAddresses", "198.51.100.2")
 *                     ))
 *                 ))
 *             .teamsVoicemailPilotNumber("1234567890")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:voiceservices:CommunicationsGateway myname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VoiceServices/communicationsGateways/{communicationsGatewayName}
 * ```
 */
public class CommunicationsGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.voiceservices.CommunicationsGateway,
) : KotlinCustomResource(javaResource, CommunicationsGatewayMapper) {
    /**
     * Details of API bridge functionality, if required
     */
    public val apiBridge: Output<Any>?
        get() = javaResource.apiBridge().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The autogenerated label used as part of the FQDNs for accessing the Communications Gateway
     */
    public val autoGeneratedDomainNameLabel: Output<String>
        get() = javaResource.autoGeneratedDomainNameLabel().applyValue({ args0 -> args0 })

    /**
     * The scope at which the auto-generated domain name can be re-used
     */
    public val autoGeneratedDomainNameLabelScope: Output<String>?
        get() = javaResource.autoGeneratedDomainNameLabelScope().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Voice codecs to support
     */
    public val codecs: Output<List<String>>
        get() = javaResource.codecs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * How to connect back to the operator network, e.g. MAPS
     */
    public val connectivity: Output<String>
        get() = javaResource.connectivity().applyValue({ args0 -> args0 })

    /**
     * How to handle 911 calls
     */
    public val e911Type: Output<String>
        get() = javaResource.e911Type().applyValue({ args0 -> args0 })

    /**
     * A list of dial strings used for emergency calling.
     */
    public val emergencyDialStrings: Output<List<String>>?
        get() = javaResource.emergencyDialStrings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Whether an integrated Mobile Control Point is in use.
     */
    public val integratedMcpEnabled: Output<Boolean>?
        get() = javaResource.integratedMcpEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether an on-premises Mobile Control Point is in use.
     */
    public val onPremMcpEnabled: Output<Boolean>?
        get() = javaResource.onPremMcpEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * What platforms to support
     */
    public val platforms: Output<List<String>>
        get() = javaResource.platforms().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The regions in which to deploy the resources needed for Teams Calling
     */
    public val serviceLocations: Output<List<ServiceRegionPropertiesResponse>>
        get() = javaResource.serviceLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceRegionPropertiesResponseToKotlin(args0) })
            })
        })

    /**
     * The current status of the deployment.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
     */
    public val teamsVoicemailPilotNumber: Output<String>?
        get() = javaResource.teamsVoicemailPilotNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CommunicationsGatewayMapper : ResourceMapper<CommunicationsGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.voiceservices.CommunicationsGateway::class == javaResource::class

    override fun map(javaResource: Resource): CommunicationsGateway =
        CommunicationsGateway(
            javaResource as
                com.pulumi.azurenative.voiceservices.CommunicationsGateway,
        )
}

/**
 * @see [CommunicationsGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommunicationsGateway].
 */
public suspend fun communicationsGateway(
    name: String,
    block: suspend CommunicationsGatewayResourceBuilder.() -> Unit,
): CommunicationsGateway {
    val builder = CommunicationsGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommunicationsGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun communicationsGateway(name: String): CommunicationsGateway {
    val builder = CommunicationsGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
