@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.inputs

import com.pulumi.azurenative.voiceservices.inputs.GetTestLinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property communicationsGatewayName Unique identifier for this deployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testLineName Unique identifier for this test line
 */
public data class GetTestLinePlainArgs(
    public val communicationsGatewayName: String,
    public val resourceGroupName: String,
    public val testLineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.inputs.GetTestLinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.inputs.GetTestLinePlainArgs =
        com.pulumi.azurenative.voiceservices.inputs.GetTestLinePlainArgs.builder()
            .communicationsGatewayName(communicationsGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testLineName(testLineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTestLinePlainArgs].
 */
@PulumiTagMarker
public class GetTestLinePlainArgsBuilder internal constructor() {
    private var communicationsGatewayName: String? = null

    private var resourceGroupName: String? = null

    private var testLineName: String? = null

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("ssslxwjdwelehcwl")
    public suspend fun communicationsGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.communicationsGatewayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iypxycmrlfyxkmti")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique identifier for this test line
     */
    @JvmName("fkkoihjusixvwsdv")
    public suspend fun testLineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testLineName = mapped
    }

    internal fun build(): GetTestLinePlainArgs = GetTestLinePlainArgs(
        communicationsGatewayName = communicationsGatewayName ?: throw
            PulumiNullFieldException("communicationsGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testLineName = testLineName ?: throw PulumiNullFieldException("testLineName"),
    )
}
