@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A TestLine resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property phoneNumber The phone number
 * @property provisioningState Resource provisioning state.
 * @property purpose Purpose of this test line, e.g. automated or manual testing
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTestLineResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val phoneNumber: String,
    public val provisioningState: String,
    public val purpose: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.outputs.GetTestLineResult):
            GetTestLineResult = GetTestLineResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            phoneNumber = javaType.phoneNumber(),
            provisioningState = javaType.provisioningState(),
            purpose = javaType.purpose(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
