@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.AseV3NetworkingConfigurationResponse
import com.pulumi.azurenative.web.kotlin.outputs.CustomDnsSuffixConfigurationResponse
import com.pulumi.azurenative.web.kotlin.outputs.NameValuePairResponse
import com.pulumi.azurenative.web.kotlin.outputs.VirtualNetworkProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.web.kotlin.outputs.AseV3NetworkingConfigurationResponse.Companion.toKotlin as aseV3NetworkingConfigurationResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.CustomDnsSuffixConfigurationResponse.Companion.toKotlin as customDnsSuffixConfigurationResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.NameValuePairResponse.Companion.toKotlin as nameValuePairResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.VirtualNetworkProfileResponse.Companion.toKotlin as virtualNetworkProfileResponseToKotlin

/**
 * Builder for [AppServiceEnvironment].
 */
@PulumiTagMarker
public class AppServiceEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppServiceEnvironmentArgs = AppServiceEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppServiceEnvironmentArgsBuilder.() -> Unit) {
        val builder = AppServiceEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AppServiceEnvironment {
        val builtJavaResource =
            com.pulumi.azurenative.web.AppServiceEnvironment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppServiceEnvironment(builtJavaResource)
    }
}

/**
 * App Service Environment ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-08-01, 2020-10-01, 2021-01-15, 2023-01-01.
 * ## Example Usage
 * ### Create or update an App Service Environment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceEnvironment = new AzureNative.Web.AppServiceEnvironment("appServiceEnvironment", new()
 *     {
 *         Kind = "Asev3",
 *         Location = "South Central US",
 *         Name = "test-ase",
 *         ResourceGroupName = "test-rg",
 *         VirtualNetwork = new AzureNative.Web.Inputs.VirtualNetworkProfileArgs
 *         {
 *             Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServiceEnvironment(ctx, "appServiceEnvironment", &web.AppServiceEnvironmentArgs{
 * 			Kind:              pulumi.String("Asev3"),
 * 			Location:          pulumi.String("South Central US"),
 * 			Name:              pulumi.String("test-ase"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			VirtualNetwork: &web.VirtualNetworkProfileArgs{
 * 				Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServiceEnvironment;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceEnvironment = new AppServiceEnvironment("appServiceEnvironment", AppServiceEnvironmentArgs.builder()
 *             .kind("Asev3")
 *             .location("South Central US")
 *             .name("test-ase")
 *             .resourceGroupName("test-rg")
 *             .virtualNetwork(Map.of("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServiceEnvironment test-ase /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}
 * ```
 */
public class AppServiceEnvironment internal constructor(
    override val javaResource: com.pulumi.azurenative.web.AppServiceEnvironment,
) : KotlinCustomResource(javaResource, AppServiceEnvironmentMapper) {
    /**
     * Custom settings for changing the behavior of the App Service Environment.
     */
    public val clusterSettings: Output<List<NameValuePairResponse>>?
        get() = javaResource.clusterSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        nameValuePairResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Full view of the custom domain suffix configuration for ASEv3.
     */
    public val customDnsSuffixConfiguration: Output<CustomDnsSuffixConfigurationResponse>?
        get() = javaResource.customDnsSuffixConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customDnsSuffixConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Dedicated Host Count
     */
    public val dedicatedHostCount: Output<Int>?
        get() = javaResource.dedicatedHostCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DNS suffix of the App Service Environment.
     */
    public val dnsSuffix: Output<String>?
        get() = javaResource.dnsSuffix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Scale factor for front-ends.
     */
    public val frontEndScaleFactor: Output<Int>?
        get() = javaResource.frontEndScaleFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag that displays whether an ASE has linux workers or not
     */
    public val hasLinuxWorkers: Output<Boolean>
        get() = javaResource.hasLinuxWorkers().applyValue({ args0 -> args0 })

    /**
     * Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
     */
    public val internalLoadBalancingMode: Output<String>?
        get() = javaResource.internalLoadBalancingMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of IP SSL addresses reserved for the App Service Environment.
     */
    public val ipsslAddressCount: Output<Int>?
        get() = javaResource.ipsslAddressCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maximum number of VMs in the App Service Environment.
     */
    public val maximumNumberOfMachines: Output<Int>
        get() = javaResource.maximumNumberOfMachines().applyValue({ args0 -> args0 })

    /**
     * Number of front-end instances.
     */
    public val multiRoleCount: Output<Int>
        get() = javaResource.multiRoleCount().applyValue({ args0 -> args0 })

    /**
     * Front-end VM size, e.g. "Medium", "Large".
     */
    public val multiSize: Output<String>?
        get() = javaResource.multiSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Full view of networking configuration for an ASE.
     */
    public val networkingConfiguration: Output<AseV3NetworkingConfigurationResponse>?
        get() = javaResource.networkingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> aseV3NetworkingConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the App Service Environment.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Current status of the App Service Environment.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * <code>true</code> if the App Service Environment is suspended; otherwise, <code>false</code>. The environment can be suspended, e.g. when the management endpoint is no longer available
     *  (most likely because NSG blocked the incoming traffic).
     */
    public val suspended: Output<Boolean>
        get() = javaResource.suspended().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether an upgrade is available for this App Service Environment.
     */
    public val upgradeAvailability: Output<String>
        get() = javaResource.upgradeAvailability().applyValue({ args0 -> args0 })

    /**
     * Upgrade Preference
     */
    public val upgradePreference: Output<String>?
        get() = javaResource.upgradePreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User added ip ranges to whitelist on ASE db
     */
    public val userWhitelistedIpRanges: Output<List<String>>?
        get() = javaResource.userWhitelistedIpRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Description of the Virtual Network.
     */
    public val virtualNetwork: Output<VirtualNetworkProfileResponse>
        get() = javaResource.virtualNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualNetworkProfileResponseToKotlin(args0)
            })
        })

    /**
     * Whether or not this App Service Environment is zone-redundant.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AppServiceEnvironmentMapper : ResourceMapper<AppServiceEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.AppServiceEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): AppServiceEnvironment =
        AppServiceEnvironment(javaResource as com.pulumi.azurenative.web.AppServiceEnvironment)
}

/**
 * @see [AppServiceEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServiceEnvironment].
 */
public suspend fun appServiceEnvironment(
    name: String,
    block: suspend AppServiceEnvironmentResourceBuilder.() -> Unit,
): AppServiceEnvironment {
    val builder = AppServiceEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServiceEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServiceEnvironment(name: String): AppServiceEnvironment {
    val builder = AppServiceEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
