@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.CustomApiArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.CustomApiPropertiesDefinitionArgs
import com.pulumi.azurenative.web.kotlin.inputs.CustomApiPropertiesDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A custom API
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * ## Example Usage
 * ### Replace a custom API
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customApi = new AzureNative.Web.CustomApi("customApi", new()
 *     {
 *         ApiName = "testCustomApi",
 *         Properties = new AzureNative.Web.Inputs.CustomApiPropertiesDefinitionArgs
 *         {
 *             ApiDefinitions = new AzureNative.Web.Inputs.ApiResourceDefinitionsArgs
 *             {
 *                 OriginalSwaggerUrl = "https://tempuri.org/swagger.json",
 *             },
 *             ApiType = "Rest",
 *             Capabilities = new() { },
 *             Description = "",
 *             DisplayName = "testCustomApi",
 *             IconUri = "/testIcon.svg",
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewCustomApi(ctx, "customApi", &web.CustomApiArgs{
 * 			ApiName: pulumi.String("testCustomApi"),
 * 			Properties: web.CustomApiPropertiesDefinitionResponse{
 * 				ApiDefinitions: &web.ApiResourceDefinitionsArgs{
 * 					OriginalSwaggerUrl: pulumi.String("https://tempuri.org/swagger.json"),
 * 				},
 * 				ApiType:      pulumi.String("Rest"),
 * 				Capabilities: pulumi.StringArray{},
 * 				Description:  pulumi.String(""),
 * 				DisplayName:  pulumi.String("testCustomApi"),
 * 				IconUri:      pulumi.String("/testIcon.svg"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.CustomApi;
 * import com.pulumi.azurenative.web.CustomApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customApi = new CustomApi("customApi", CustomApiArgs.builder()
 *             .apiName("testCustomApi")
 *             .properties(Map.ofEntries(
 *                 Map.entry("apiDefinitions", Map.of("originalSwaggerUrl", "https://tempuri.org/swagger.json")),
 *                 Map.entry("apiType", "Rest"),
 *                 Map.entry("capabilities", ),
 *                 Map.entry("description", ""),
 *                 Map.entry("displayName", "testCustomApi"),
 *                 Map.entry("iconUri", "/testIcon.svg")
 *             ))
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:CustomApi testCustomApi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}
 * ```
 * @property apiName API name
 * @property location Resource location
 * @property properties Custom API properties
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 * @property tags Resource tags
 */
public data class CustomApiArgs(
    public val apiName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<CustomApiPropertiesDefinitionArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.CustomApiArgs> {
    override fun toJava(): com.pulumi.azurenative.web.CustomApiArgs =
        com.pulumi.azurenative.web.CustomApiArgs.builder()
            .apiName(apiName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomApiArgs].
 */
@PulumiTagMarker
public class CustomApiArgsBuilder internal constructor() {
    private var apiName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<CustomApiPropertiesDefinitionArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value API name
     */
    @JvmName("iopiqiveqqavepwu")
    public suspend fun apiName(`value`: Output<String>) {
        this.apiName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("lfvigopdvsnojfsv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Custom API properties
     */
    @JvmName("rivrpklmgsxlwuas")
    public suspend fun properties(`value`: Output<CustomApiPropertiesDefinitionArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group
     */
    @JvmName("ylmvkoultotgjake")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("jsvmjuwgttekceqa")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("eumxxlqrbdtyyuxw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value API name
     */
    @JvmName("fokypxmkqpefoncf")
    public suspend fun apiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("euondqgpasrrucxu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Custom API properties
     */
    @JvmName("ohigollhybuldcms")
    public suspend fun properties(`value`: CustomApiPropertiesDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Custom API properties
     */
    @JvmName("nsophbcaddkhelfa")
    public suspend
    fun properties(argument: suspend CustomApiPropertiesDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = CustomApiPropertiesDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("bugftiejddmurcat")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("vweealfpiqqcomhx")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("micebonvyfmcsdvj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("oxfjpffeaeasasyc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomApiArgs = CustomApiArgs(
        apiName = apiName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
    )
}
