@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.KubeEnvironmentArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.AppLogsConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.AppLogsConfigurationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.ArcConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.ArcConfigurationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.ContainerAppsConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.ContainerAppsConfigurationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.web.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Kubernetes cluster specialized for web workloads by Azure App Service
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create kube environments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kubeEnvironment = new AzureNative.Web.KubeEnvironment("kubeEnvironment", new()
 *     {
 *         Location = "East US",
 *         Name = "testkubeenv",
 *         ResourceGroupName = "examplerg",
 *         StaticIp = "1.2.3.4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewKubeEnvironment(ctx, "kubeEnvironment", &web.KubeEnvironmentArgs{
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testkubeenv"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			StaticIp:          pulumi.String("1.2.3.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.KubeEnvironment;
 * import com.pulumi.azurenative.web.KubeEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kubeEnvironment = new KubeEnvironment("kubeEnvironment", KubeEnvironmentArgs.builder()
 *             .location("East US")
 *             .name("testkubeenv")
 *             .resourceGroupName("examplerg")
 *             .staticIp("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:KubeEnvironment testkubeenv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/kubeEnvironments/{name}
 * ```
 * @property aksResourceID
 * @property appLogsConfiguration Cluster configuration which enables the log daemon to export
 * app logs to a destination. Currently only "log-analytics" is
 * supported
 * @property arcConfiguration Cluster configuration which determines the ARC cluster
 * components types. Eg: Choosing between BuildService kind,
 * FrontEnd Service ArtifactsStorageType etc.
 * @property containerAppsConfiguration Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
 * @property environmentType Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
 * @property extendedLocation Extended Location.
 * @property internalLoadBalancerEnabled Only visible within Vnet/Subnet
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Name of the Kubernetes Environment.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property staticIp Static IP of the KubeEnvironment
 * @property tags Resource tags.
 */
public data class KubeEnvironmentArgs(
    public val aksResourceID: Output<String>? = null,
    public val appLogsConfiguration: Output<AppLogsConfigurationArgs>? = null,
    public val arcConfiguration: Output<ArcConfigurationArgs>? = null,
    public val containerAppsConfiguration: Output<ContainerAppsConfigurationArgs>? = null,
    public val environmentType: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val internalLoadBalancerEnabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val staticIp: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.KubeEnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.web.KubeEnvironmentArgs =
        com.pulumi.azurenative.web.KubeEnvironmentArgs.builder()
            .aksResourceID(aksResourceID?.applyValue({ args0 -> args0 }))
            .appLogsConfiguration(
                appLogsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .arcConfiguration(arcConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerAppsConfiguration(
                containerAppsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .environmentType(environmentType?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .internalLoadBalancerEnabled(internalLoadBalancerEnabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .staticIp(staticIp?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KubeEnvironmentArgs].
 */
@PulumiTagMarker
public class KubeEnvironmentArgsBuilder internal constructor() {
    private var aksResourceID: Output<String>? = null

    private var appLogsConfiguration: Output<AppLogsConfigurationArgs>? = null

    private var arcConfiguration: Output<ArcConfigurationArgs>? = null

    private var containerAppsConfiguration: Output<ContainerAppsConfigurationArgs>? = null

    private var environmentType: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var internalLoadBalancerEnabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var staticIp: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("sdwndmyuhfahuwin")
    public suspend fun aksResourceID(`value`: Output<String>) {
        this.aksResourceID = value
    }

    /**
     * @param value Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    @JvmName("tioegmgdqintqyug")
    public suspend fun appLogsConfiguration(`value`: Output<AppLogsConfigurationArgs>) {
        this.appLogsConfiguration = value
    }

    /**
     * @param value Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     */
    @JvmName("bdwyxlwlgfvcoths")
    public suspend fun arcConfiguration(`value`: Output<ArcConfigurationArgs>) {
        this.arcConfiguration = value
    }

    /**
     * @param value Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
     */
    @JvmName("ktwninlidskvskut")
    public suspend fun containerAppsConfiguration(`value`: Output<ContainerAppsConfigurationArgs>) {
        this.containerAppsConfiguration = value
    }

    /**
     * @param value Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
     */
    @JvmName("gypqigwkkxlvttkq")
    public suspend fun environmentType(`value`: Output<String>) {
        this.environmentType = value
    }

    /**
     * @param value Extended Location.
     */
    @JvmName("qrtetjxsfhsgvlrn")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Only visible within Vnet/Subnet
     */
    @JvmName("afglbogbfgnbdser")
    public suspend fun internalLoadBalancerEnabled(`value`: Output<Boolean>) {
        this.internalLoadBalancerEnabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("rciqtgpeihmqslhr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("rgbdewawvwtecitl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Kubernetes Environment.
     */
    @JvmName("patnkkgpungygagm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("guncqrtihvrnqnsu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Static IP of the KubeEnvironment
     */
    @JvmName("xwrwnegcelkppwty")
    public suspend fun staticIp(`value`: Output<String>) {
        this.staticIp = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kodstroacjbvwwwq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("uceinyidfuitbayb")
    public suspend fun aksResourceID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aksResourceID = mapped
    }

    /**
     * @param value Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    @JvmName("orixfgjfetivkaof")
    public suspend fun appLogsConfiguration(`value`: AppLogsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appLogsConfiguration = mapped
    }

    /**
     * @param argument Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    @JvmName("erdcglxuhebrhglm")
    public suspend
    fun appLogsConfiguration(argument: suspend AppLogsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AppLogsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.appLogsConfiguration = mapped
    }

    /**
     * @param value Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     */
    @JvmName("kxvytbwftpskdibn")
    public suspend fun arcConfiguration(`value`: ArcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcConfiguration = mapped
    }

    /**
     * @param argument Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     */
    @JvmName("csuqygeudithfiqp")
    public suspend fun arcConfiguration(argument: suspend ArcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ArcConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.arcConfiguration = mapped
    }

    /**
     * @param value Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
     */
    @JvmName("dhuccavcuidhankr")
    public suspend fun containerAppsConfiguration(`value`: ContainerAppsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerAppsConfiguration = mapped
    }

    /**
     * @param argument Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
     */
    @JvmName("geahclkxmpidmbwx")
    public suspend
    fun containerAppsConfiguration(argument: suspend ContainerAppsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerAppsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerAppsConfiguration = mapped
    }

    /**
     * @param value Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
     */
    @JvmName("dgeqywacgddmwpwn")
    public suspend fun environmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value Extended Location.
     */
    @JvmName("dpwvvyhhlpbfrqsd")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location.
     */
    @JvmName("pdfefksccjprvtbq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Only visible within Vnet/Subnet
     */
    @JvmName("npkfvbyhuvvoavtc")
    public suspend fun internalLoadBalancerEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalLoadBalancerEnabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("anqcaoisklhfawai")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("uyynubpsvuwwjbgl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Kubernetes Environment.
     */
    @JvmName("pysxprrkjxvqrnqa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("astqsdvcscwhirms")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Static IP of the KubeEnvironment
     */
    @JvmName("tftfpqgyqllsvrbq")
    public suspend fun staticIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIp = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ginhllvtwynuxfax")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fwqpoebwhofhicqh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KubeEnvironmentArgs = KubeEnvironmentArgs(
        aksResourceID = aksResourceID,
        appLogsConfiguration = appLogsConfiguration,
        arcConfiguration = arcConfiguration,
        containerAppsConfiguration = containerAppsConfiguration,
        environmentType = environmentType,
        extendedLocation = extendedLocation,
        internalLoadBalancerEnabled = internalLoadBalancerEnabled,
        kind = kind,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        staticIp = staticIp,
        tags = tags,
    )
}
