@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [StaticSiteDatabaseConnection].
 */
@PulumiTagMarker
public class StaticSiteDatabaseConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteDatabaseConnectionArgs = StaticSiteDatabaseConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticSiteDatabaseConnectionArgsBuilder.() -> Unit) {
        val builder = StaticSiteDatabaseConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StaticSiteDatabaseConnection {
        val builtJavaResource =
            com.pulumi.azurenative.web.StaticSiteDatabaseConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StaticSiteDatabaseConnection(builtJavaResource)
    }
}

/**
 * Static Site Database Connection resource.
 * Azure REST API version: 2022-09-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create or update a database connection for a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteDatabaseConnection = new AzureNative.Web.StaticSiteDatabaseConnection("staticSiteDatabaseConnection", new()
 *     {
 *         ConnectionIdentity = "SystemAssigned",
 *         ConnectionString = "AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;",
 *         DatabaseConnectionName = "default",
 *         Name = "testStaticSite0",
 *         Region = "West US 2",
 *         ResourceGroupName = "rg",
 *         ResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteDatabaseConnection(ctx, "staticSiteDatabaseConnection", &web.StaticSiteDatabaseConnectionArgs{
 * 			ConnectionIdentity:     pulumi.String("SystemAssigned"),
 * 			ConnectionString:       pulumi.String("AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;"),
 * 			DatabaseConnectionName: pulumi.String("default"),
 * 			Name:                   pulumi.String("testStaticSite0"),
 * 			Region:                 pulumi.String("West US 2"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			ResourceId:             pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteDatabaseConnection;
 * import com.pulumi.azurenative.web.StaticSiteDatabaseConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteDatabaseConnection = new StaticSiteDatabaseConnection("staticSiteDatabaseConnection", StaticSiteDatabaseConnectionArgs.builder()
 *             .connectionIdentity("SystemAssigned")
 *             .connectionString("AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;")
 *             .databaseConnectionName("default")
 *             .name("testStaticSite0")
 *             .region("West US 2")
 *             .resourceGroupName("rg")
 *             .resourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteDatabaseConnection default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}
 * ```
 */
public class StaticSiteDatabaseConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.web.StaticSiteDatabaseConnection,
) : KotlinCustomResource(javaResource, StaticSiteDatabaseConnectionMapper) {
    /**
     * A list of configuration files associated with this database connection.
     */
    public val configurationFiles:
        Output<List<StaticSiteDatabaseConnectionConfigurationFileOverviewResponse>>
        get() = javaResource.configurationFiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
     */
    public val connectionIdentity: Output<String>?
        get() = javaResource.connectionIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection string to use to connect to the database.
     */
    public val connectionString: Output<String>?
        get() = javaResource.connectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The region of the database resource.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * The resource id of the database.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StaticSiteDatabaseConnectionMapper : ResourceMapper<StaticSiteDatabaseConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSiteDatabaseConnection::class == javaResource::class

    override fun map(javaResource: Resource): StaticSiteDatabaseConnection =
        StaticSiteDatabaseConnection(
            javaResource as
                com.pulumi.azurenative.web.StaticSiteDatabaseConnection,
        )
}

/**
 * @see [StaticSiteDatabaseConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSiteDatabaseConnection].
 */
public suspend fun staticSiteDatabaseConnection(
    name: String,
    block: suspend StaticSiteDatabaseConnectionResourceBuilder.() -> Unit,
):
    StaticSiteDatabaseConnection {
    val builder = StaticSiteDatabaseConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSiteDatabaseConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSiteDatabaseConnection(name: String): StaticSiteDatabaseConnection {
    val builder = StaticSiteDatabaseConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
