@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.StaticSiteDatabaseConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Static Site Database Connection resource.
 * Azure REST API version: 2022-09-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create or update a database connection for a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteDatabaseConnection = new AzureNative.Web.StaticSiteDatabaseConnection("staticSiteDatabaseConnection", new()
 *     {
 *         ConnectionIdentity = "SystemAssigned",
 *         ConnectionString = "AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;",
 *         DatabaseConnectionName = "default",
 *         Name = "testStaticSite0",
 *         Region = "West US 2",
 *         ResourceGroupName = "rg",
 *         ResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteDatabaseConnection(ctx, "staticSiteDatabaseConnection", &web.StaticSiteDatabaseConnectionArgs{
 * 			ConnectionIdentity:     pulumi.String("SystemAssigned"),
 * 			ConnectionString:       pulumi.String("AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;"),
 * 			DatabaseConnectionName: pulumi.String("default"),
 * 			Name:                   pulumi.String("testStaticSite0"),
 * 			Region:                 pulumi.String("West US 2"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			ResourceId:             pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteDatabaseConnection;
 * import com.pulumi.azurenative.web.StaticSiteDatabaseConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteDatabaseConnection = new StaticSiteDatabaseConnection("staticSiteDatabaseConnection", StaticSiteDatabaseConnectionArgs.builder()
 *             .connectionIdentity("SystemAssigned")
 *             .connectionString("AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;")
 *             .databaseConnectionName("default")
 *             .name("testStaticSite0")
 *             .region("West US 2")
 *             .resourceGroupName("rg")
 *             .resourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteDatabaseConnection default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/databaseConnections/{databaseConnectionName}
 * ```
 * @property connectionIdentity If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
 * @property connectionString The connection string to use to connect to the database.
 * @property databaseConnectionName Name of the database connection.
 * @property kind Kind of resource.
 * @property name Name of the static site
 * @property region The region of the database resource.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property resourceId The resource id of the database.
 */
public data class StaticSiteDatabaseConnectionArgs(
    public val connectionIdentity: Output<String>? = null,
    public val connectionString: Output<String>? = null,
    public val databaseConnectionName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val region: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.StaticSiteDatabaseConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.StaticSiteDatabaseConnectionArgs =
        com.pulumi.azurenative.web.StaticSiteDatabaseConnectionArgs.builder()
            .connectionIdentity(connectionIdentity?.applyValue({ args0 -> args0 }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .databaseConnectionName(databaseConnectionName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticSiteDatabaseConnectionArgs].
 */
@PulumiTagMarker
public class StaticSiteDatabaseConnectionArgsBuilder internal constructor() {
    private var connectionIdentity: Output<String>? = null

    private var connectionString: Output<String>? = null

    private var databaseConnectionName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var region: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
     */
    @JvmName("sjwrqqumcigvxpof")
    public suspend fun connectionIdentity(`value`: Output<String>) {
        this.connectionIdentity = value
    }

    /**
     * @param value The connection string to use to connect to the database.
     */
    @JvmName("ievomjnnnwtugatn")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Name of the database connection.
     */
    @JvmName("itkskcskogksstgk")
    public suspend fun databaseConnectionName(`value`: Output<String>) {
        this.databaseConnectionName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xrdfykmuhqsreikt")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("iquixcavbfkvpcms")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The region of the database resource.
     */
    @JvmName("eypbccgdpjdaswld")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("okyejkemrbfyfkhh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource id of the database.
     */
    @JvmName("bjbwxodvnhxogyag")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
     */
    @JvmName("djwfsdyvpgtfmfwg")
    public suspend fun connectionIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionIdentity = mapped
    }

    /**
     * @param value The connection string to use to connect to the database.
     */
    @JvmName("oxhlfbydsbtcadqo")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Name of the database connection.
     */
    @JvmName("jiywgbblvahuvaij")
    public suspend fun databaseConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseConnectionName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("iojuelwxjydhvsxo")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("nfmhctbjgxknfitw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The region of the database resource.
     */
    @JvmName("fjfotbgxrstjoxwf")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("gqtthfbddokqxbwy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource id of the database.
     */
    @JvmName("jekbggexrcwmdtsc")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): StaticSiteDatabaseConnectionArgs = StaticSiteDatabaseConnectionArgs(
        connectionIdentity = connectionIdentity,
        connectionString = connectionString,
        databaseConnectionName = databaseConnectionName,
        kind = kind,
        name = name,
        region = region,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
    )
}
