@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticSiteLinkedBackend].
 */
@PulumiTagMarker
public class StaticSiteLinkedBackendResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteLinkedBackendArgs = StaticSiteLinkedBackendArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticSiteLinkedBackendArgsBuilder.() -> Unit) {
        val builder = StaticSiteLinkedBackendArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StaticSiteLinkedBackend {
        val builtJavaResource =
            com.pulumi.azurenative.web.StaticSiteLinkedBackend(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StaticSiteLinkedBackend(builtJavaResource)
    }
}

/**
 * Static Site Linked Backend ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Link a backend to a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteLinkedBackend = new AzureNative.Web.StaticSiteLinkedBackend("staticSiteLinkedBackend", new()
 *     {
 *         BackendResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend",
 *         LinkedBackendName = "testBackend",
 *         Name = "testStaticSite0",
 *         Region = "West US 2",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteLinkedBackend(ctx, "staticSiteLinkedBackend", &web.StaticSiteLinkedBackendArgs{
 * 			BackendResourceId: pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend"),
 * 			LinkedBackendName: pulumi.String("testBackend"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			Region:            pulumi.String("West US 2"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteLinkedBackend;
 * import com.pulumi.azurenative.web.StaticSiteLinkedBackendArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteLinkedBackend = new StaticSiteLinkedBackend("staticSiteLinkedBackend", StaticSiteLinkedBackendArgs.builder()
 *             .backendResourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend")
 *             .linkedBackendName("testBackend")
 *             .name("testStaticSite0")
 *             .region("West US 2")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteLinkedBackend testBackend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/linkedBackends/{linkedBackendName}
 * ```
 */
public class StaticSiteLinkedBackend internal constructor(
    override val javaResource: com.pulumi.azurenative.web.StaticSiteLinkedBackend,
) : KotlinCustomResource(javaResource, StaticSiteLinkedBackendMapper) {
    /**
     * The resource id of the backend linked to the static site
     */
    public val backendResourceId: Output<String>?
        get() = javaResource.backendResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date and time on which the backend was linked to the static site.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the linking process.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The region of the backend linked to the static site
     */
    public val region: Output<String>?
        get() = javaResource.region().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StaticSiteLinkedBackendMapper : ResourceMapper<StaticSiteLinkedBackend> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSiteLinkedBackend::class == javaResource::class

    override fun map(javaResource: Resource): StaticSiteLinkedBackend =
        StaticSiteLinkedBackend(javaResource as com.pulumi.azurenative.web.StaticSiteLinkedBackend)
}

/**
 * @see [StaticSiteLinkedBackend].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSiteLinkedBackend].
 */
public suspend fun staticSiteLinkedBackend(
    name: String,
    block: suspend StaticSiteLinkedBackendResourceBuilder.() -> Unit,
): StaticSiteLinkedBackend {
    val builder = StaticSiteLinkedBackendResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSiteLinkedBackend].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSiteLinkedBackend(name: String): StaticSiteLinkedBackend {
    val builder = StaticSiteLinkedBackendResourceBuilder()
    builder.name(name)
    return builder.build()
}
