@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppApplicationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Update App Settings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppApplicationSettings = new AzureNative.Web.WebAppApplicationSettings("webAppApplicationSettings", new()
 *     {
 *         Name = "sitef6141",
 *         Properties =
 *         {
 *             { "Setting1", "Value1" },
 *             { "Setting2", "Value2" },
 *         },
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppApplicationSettings(ctx, "webAppApplicationSettings", &web.WebAppApplicationSettingsArgs{
 * 			Name: pulumi.String("sitef6141"),
 * 			Properties: pulumi.StringMap{
 * 				"Setting1": pulumi.String("Value1"),
 * 				"Setting2": pulumi.String("Value2"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppApplicationSettings;
 * import com.pulumi.azurenative.web.WebAppApplicationSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppApplicationSettings = new WebAppApplicationSettings("webAppApplicationSettings", WebAppApplicationSettingsArgs.builder()
 *             .name("sitef6141")
 *             .properties(Map.ofEntries(
 *                 Map.entry("Setting1", "Value1"),
 *                 Map.entry("Setting2", "Value2")
 *             ))
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppApplicationSettings appsettings /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property properties Settings.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppApplicationSettingsArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppApplicationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppApplicationSettingsArgs =
        com.pulumi.azurenative.web.WebAppApplicationSettingsArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppApplicationSettingsArgs].
 */
@PulumiTagMarker
public class WebAppApplicationSettingsArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("iupjytwmjarthoad")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("isnqsidtvanprvgt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Settings.
     */
    @JvmName("klombyilnywgykpv")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bqlbrxnnjfeiaogn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("gkfmnxbkbfvcgqhj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("fgsrhojvvhefhoua")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Settings.
     */
    @JvmName("saoxiowechjpoehd")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Settings.
     */
    @JvmName("hvtxtwvqafkmowat")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("faovdguyxyuqygss")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppApplicationSettingsArgs = WebAppApplicationSettingsArgs(
        kind = kind,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
