@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.BackupScheduleResponse
import com.pulumi.azurenative.web.kotlin.outputs.DatabaseBackupSettingResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.web.kotlin.outputs.BackupScheduleResponse.Companion.toKotlin as backupScheduleResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.DatabaseBackupSettingResponse.Companion.toKotlin as databaseBackupSettingResponseToKotlin

/**
 * Builder for [WebAppBackupConfiguration].
 */
@PulumiTagMarker
public class WebAppBackupConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppBackupConfigurationArgs = WebAppBackupConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppBackupConfigurationArgsBuilder.() -> Unit) {
        val builder = WebAppBackupConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppBackupConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppBackupConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppBackupConfiguration(builtJavaResource)
    }
}

/**
 * Description of a backup which will be performed.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppBackupConfiguration myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup
 * ```
 */
public class WebAppBackupConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppBackupConfiguration,
) : KotlinCustomResource(javaResource, WebAppBackupConfigurationMapper) {
    /**
     * Name of the backup.
     */
    public val backupName: Output<String>?
        get() = javaResource.backupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schedule for the backup if it is executed periodically.
     */
    public val backupSchedule: Output<BackupScheduleResponse>?
        get() = javaResource.backupSchedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> backupScheduleResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Databases included in the backup.
     */
    public val databases: Output<List<DatabaseBackupSettingResponse>>?
        get() = javaResource.databases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> databaseBackupSettingResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SAS URL to the container.
     */
    public val storageAccountUrl: Output<String>
        get() = javaResource.storageAccountUrl().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppBackupConfigurationMapper : ResourceMapper<WebAppBackupConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppBackupConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): WebAppBackupConfiguration =
        WebAppBackupConfiguration(
            javaResource as
                com.pulumi.azurenative.web.WebAppBackupConfiguration,
        )
}

/**
 * @see [WebAppBackupConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppBackupConfiguration].
 */
public suspend fun webAppBackupConfiguration(
    name: String,
    block: suspend WebAppBackupConfigurationResourceBuilder.() -> Unit,
): WebAppBackupConfiguration {
    val builder = WebAppBackupConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppBackupConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppBackupConfiguration(name: String): WebAppBackupConfiguration {
    val builder = WebAppBackupConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
