@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppMetadata].
 */
@PulumiTagMarker
public class WebAppMetadataResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppMetadataArgs = WebAppMetadataArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppMetadataArgsBuilder.() -> Unit) {
        val builder = WebAppMetadataArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppMetadata {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppMetadata(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppMetadata(builtJavaResource)
    }
}

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppMetadata myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata
 * ```
 */
public class WebAppMetadata internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppMetadata,
) : KotlinCustomResource(javaResource, WebAppMetadataMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Settings.
     */
    public val properties: Output<Map<String, String>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppMetadataMapper : ResourceMapper<WebAppMetadata> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppMetadata::class == javaResource::class

    override fun map(javaResource: Resource): WebAppMetadata = WebAppMetadata(
        javaResource as
            com.pulumi.azurenative.web.WebAppMetadata,
    )
}

/**
 * @see [WebAppMetadata].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppMetadata].
 */
public suspend fun webAppMetadata(
    name: String,
    block: suspend WebAppMetadataResourceBuilder.() -> Unit,
): WebAppMetadata {
    val builder = WebAppMetadataResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppMetadata].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppMetadata(name: String): WebAppMetadata {
    val builder = WebAppMetadataResourceBuilder()
    builder.name(name)
    return builder.build()
}
