@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.PrivateLinkConnectionStateArgs
import com.pulumi.azurenative.web.kotlin.inputs.PrivateLinkConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Remote Private Endpoint Connection ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Approves or rejects a private endpoint connection for a site.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppPrivateEndpointConnectionSlot = new AzureNative.Web.WebAppPrivateEndpointConnectionSlot("webAppPrivateEndpointConnectionSlot", new()
 *     {
 *         Name = "testSite",
 *         PrivateEndpointConnectionName = "connection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Web.Inputs.PrivateLinkConnectionStateArgs
 *         {
 *             ActionsRequired = "",
 *             Description = "Approved by admin.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg",
 *         Slot = "stage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppPrivateEndpointConnectionSlot(ctx, "webAppPrivateEndpointConnectionSlot", &web.WebAppPrivateEndpointConnectionSlotArgs{
 * 			Name:                          pulumi.String("testSite"),
 * 			PrivateEndpointConnectionName: pulumi.String("connection"),
 * 			PrivateLinkServiceConnectionState: &web.PrivateLinkConnectionStateArgs{
 * 				ActionsRequired: pulumi.String(""),
 * 				Description:     pulumi.String("Approved by admin."),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Slot:              pulumi.String("stage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionSlot;
 * import com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionSlotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppPrivateEndpointConnectionSlot = new WebAppPrivateEndpointConnectionSlot("webAppPrivateEndpointConnectionSlot", WebAppPrivateEndpointConnectionSlotArgs.builder()
 *             .name("testSite")
 *             .privateEndpointConnectionName("connection")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", ""),
 *                 Map.entry("description", "Approved by admin."),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rg")
 *             .slot("stage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPrivateEndpointConnectionSlot connection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property ipAddresses Private IPAddresses mapped to the remote private endpoint
 * @property kind Kind of resource.
 * @property name Name of the site.
 * @property privateEndpointConnectionName
 * @property privateLinkServiceConnectionState The state of a private link connection
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot
 */
public data class WebAppPrivateEndpointConnectionSlotArgs(
    public val ipAddresses: Output<List<String>>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionSlotArgs =
        com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionSlotArgs.builder()
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppPrivateEndpointConnectionSlotArgs].
 */
@PulumiTagMarker
public class WebAppPrivateEndpointConnectionSlotArgsBuilder internal constructor() {
    private var ipAddresses: Output<List<String>>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("kyiojlmcaewykkjx")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("nehibaoexonamukq")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("vtnqyqaouhjmuykf")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("lyighewritpbquqf")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the site.
     */
    @JvmName("nnfmjunbfvhcmrww")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("hpkxomxsbaceiahk")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("cbdxmkwoukeuistd")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vbxpxxdlohxqcqvw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("kjvpahnkpdiiskjp")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("hmaouovbpxjrweau")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("oufuwgapstdbwvrn")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ekmeknfnahfswamu")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the site.
     */
    @JvmName("mwiwgqpydfqyriwl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("hovqmplgwwfewbfm")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("tuqnpykxnqlmawvo")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The state of a private link connection
     */
    @JvmName("eijxacvxnxhwiyie")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("akvjevheyydjinqw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("slwrymtqivwensge")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppPrivateEndpointConnectionSlotArgs =
        WebAppPrivateEndpointConnectionSlotArgs(
            ipAddresses = ipAddresses,
            kind = kind,
            name = name,
            privateEndpointConnectionName = privateEndpointConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
            slot = slot,
        )
}
