@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppRelayServiceConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hybrid Connection for an App Service app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppRelayServiceConnection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}
 * ```
 * @property biztalkUri
 * @property entityConnectionString
 * @property entityName
 * @property hostname
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property port
 * @property resourceConnectionString
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property resourceType
 */
public data class WebAppRelayServiceConnectionArgs(
    public val biztalkUri: Output<String>? = null,
    public val entityConnectionString: Output<String>? = null,
    public val entityName: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resourceConnectionString: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppRelayServiceConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppRelayServiceConnectionArgs =
        com.pulumi.azurenative.web.WebAppRelayServiceConnectionArgs.builder()
            .biztalkUri(biztalkUri?.applyValue({ args0 -> args0 }))
            .entityConnectionString(entityConnectionString?.applyValue({ args0 -> args0 }))
            .entityName(entityName?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceConnectionString(resourceConnectionString?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppRelayServiceConnectionArgs].
 */
@PulumiTagMarker
public class WebAppRelayServiceConnectionArgsBuilder internal constructor() {
    private var biztalkUri: Output<String>? = null

    private var entityConnectionString: Output<String>? = null

    private var entityName: Output<String>? = null

    private var hostname: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    private var resourceConnectionString: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cyosxqhtciaupwge")
    public suspend fun biztalkUri(`value`: Output<String>) {
        this.biztalkUri = value
    }

    /**
     * @param value
     */
    @JvmName("rudanfhubfnciuyi")
    public suspend fun entityConnectionString(`value`: Output<String>) {
        this.entityConnectionString = value
    }

    /**
     * @param value
     */
    @JvmName("vumdsktjtvrxpxiv")
    public suspend fun entityName(`value`: Output<String>) {
        this.entityName = value
    }

    /**
     * @param value
     */
    @JvmName("sfjmnigrtikgpyhm")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("shsbieoyuweskybh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("xvjrjasqpicincsa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("lmaxfoyrajnepkpu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("jqpktjckylhkugdo")
    public suspend fun resourceConnectionString(`value`: Output<String>) {
        this.resourceConnectionString = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("oyrosihktdovdysw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("bntgcyllvxksuody")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value
     */
    @JvmName("txvmddrkfistdmrx")
    public suspend fun biztalkUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.biztalkUri = mapped
    }

    /**
     * @param value
     */
    @JvmName("xrbyfawjmhybwqpe")
    public suspend fun entityConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityConnectionString = mapped
    }

    /**
     * @param value
     */
    @JvmName("bkghhtwilnxbbpig")
    public suspend fun entityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityName = mapped
    }

    /**
     * @param value
     */
    @JvmName("phndjontgjkuhhgn")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("bttcewxvtyfaqskh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("emsshnfnncvvbuxb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("fhhgtlvvysojsxjn")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmcxdfqjeyoyaghv")
    public suspend fun resourceConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceConnectionString = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("rvxocgejnjqnukvy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("txlmtspxlkqisaam")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): WebAppRelayServiceConnectionArgs = WebAppRelayServiceConnectionArgs(
        biztalkUri = biztalkUri,
        entityConnectionString = entityConnectionString,
        entityName = entityName,
        hostname = hostname,
        kind = kind,
        name = name,
        port = port,
        resourceConnectionString = resourceConnectionString,
        resourceGroupName = resourceGroupName,
        resourceType = resourceType,
    )
}
