@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSiteExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Site Extension Information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSiteExtension myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}
 * ```
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property siteExtensionId Site extension name.
 */
public data class WebAppSiteExtensionArgs(
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteExtensionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSiteExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSiteExtensionArgs =
        com.pulumi.azurenative.web.WebAppSiteExtensionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteExtensionId(siteExtensionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSiteExtensionArgs].
 */
@PulumiTagMarker
public class WebAppSiteExtensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteExtensionId: Output<String>? = null

    /**
     * @param value Site name.
     */
    @JvmName("pfcemwipclxlhmtg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("fcpwvjveikmiarvl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site extension name.
     */
    @JvmName("oeyhgqjmcmxclixk")
    public suspend fun siteExtensionId(`value`: Output<String>) {
        this.siteExtensionId = value
    }

    /**
     * @param value Site name.
     */
    @JvmName("sqdrnksgxxfdwgbu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("iurpotsyoiwagjpt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site extension name.
     */
    @JvmName("impjlimpceiypivg")
    public suspend fun siteExtensionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteExtensionId = mapped
    }

    internal fun build(): WebAppSiteExtensionArgs = WebAppSiteExtensionArgs(
        name = name,
        resourceGroupName = resourceGroupName,
        siteExtensionId = siteExtensionId,
    )
}
