@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSitePushSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Push settings for the App.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSitePushSettings myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings
 * ```
 * @property dynamicTagsJson Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
 * @property isPushEnabled Gets or sets a flag indicating whether the Push endpoint is enabled.
 * @property kind Kind of resource.
 * @property name Name of web app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property tagWhitelistJson Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
 * @property tagsRequiringAuth Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
 * Tags can consist of alphanumeric characters and the following:
 * '_', '@', '#', '.', ':', '-'.
 * Validation should be performed at the PushRequestHandler.
 */
public data class WebAppSitePushSettingsArgs(
    public val dynamicTagsJson: Output<String>? = null,
    public val isPushEnabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tagWhitelistJson: Output<String>? = null,
    public val tagsRequiringAuth: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSitePushSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSitePushSettingsArgs =
        com.pulumi.azurenative.web.WebAppSitePushSettingsArgs.builder()
            .dynamicTagsJson(dynamicTagsJson?.applyValue({ args0 -> args0 }))
            .isPushEnabled(isPushEnabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tagWhitelistJson(tagWhitelistJson?.applyValue({ args0 -> args0 }))
            .tagsRequiringAuth(tagsRequiringAuth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSitePushSettingsArgs].
 */
@PulumiTagMarker
public class WebAppSitePushSettingsArgsBuilder internal constructor() {
    private var dynamicTagsJson: Output<String>? = null

    private var isPushEnabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tagWhitelistJson: Output<String>? = null

    private var tagsRequiringAuth: Output<String>? = null

    /**
     * @param value Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    @JvmName("hqgarxuefbuyjxqu")
    public suspend fun dynamicTagsJson(`value`: Output<String>) {
        this.dynamicTagsJson = value
    }

    /**
     * @param value Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    @JvmName("fraxoahsoavsfjtl")
    public suspend fun isPushEnabled(`value`: Output<Boolean>) {
        this.isPushEnabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("okojnbgmrmhudkfg")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("xeulsaqggkogstih")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vrxwomyaxxcgofak")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    @JvmName("gltvqrtukfgxsfst")
    public suspend fun tagWhitelistJson(`value`: Output<String>) {
        this.tagWhitelistJson = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    @JvmName("kpupxwgmtjfmscma")
    public suspend fun tagsRequiringAuth(`value`: Output<String>) {
        this.tagsRequiringAuth = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    @JvmName("xbvqffslknierrkd")
    public suspend fun dynamicTagsJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicTagsJson = mapped
    }

    /**
     * @param value Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    @JvmName("hotmdejwpihkfvxy")
    public suspend fun isPushEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPushEnabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xkqrcbmkoaipnyyp")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("cmbkhjdfcdijwfwl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("oudxahnshmovqqjp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    @JvmName("ktgynxlnrphqprio")
    public suspend fun tagWhitelistJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagWhitelistJson = mapped
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    @JvmName("iqigyhwcmmlueydy")
    public suspend fun tagsRequiringAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsRequiringAuth = mapped
    }

    internal fun build(): WebAppSitePushSettingsArgs = WebAppSitePushSettingsArgs(
        dynamicTagsJson = dynamicTagsJson,
        isPushEnabled = isPushEnabled,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        tagWhitelistJson = tagWhitelistJson,
        tagsRequiringAuth = tagsRequiringAuth,
    )
}
