@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppSitePushSettingsSlot].
 */
@PulumiTagMarker
public class WebAppSitePushSettingsSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSitePushSettingsSlotArgs = WebAppSitePushSettingsSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSitePushSettingsSlotArgsBuilder.() -> Unit) {
        val builder = WebAppSitePushSettingsSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppSitePushSettingsSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppSitePushSettingsSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSitePushSettingsSlot(builtJavaResource)
    }
}

/**
 * Push settings for the App.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSitePushSettingsSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings
 * ```
 */
public class WebAppSitePushSettingsSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppSitePushSettingsSlot,
) : KotlinCustomResource(javaResource, WebAppSitePushSettingsSlotMapper) {
    /**
     * Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    public val dynamicTagsJson: Output<String>?
        get() = javaResource.dynamicTagsJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    public val isPushEnabled: Output<Boolean>
        get() = javaResource.isPushEnabled().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    public val tagWhitelistJson: Output<String>?
        get() = javaResource.tagWhitelistJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    public val tagsRequiringAuth: Output<String>?
        get() = javaResource.tagsRequiringAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppSitePushSettingsSlotMapper : ResourceMapper<WebAppSitePushSettingsSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppSitePushSettingsSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSitePushSettingsSlot =
        WebAppSitePushSettingsSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppSitePushSettingsSlot,
        )
}

/**
 * @see [WebAppSitePushSettingsSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSitePushSettingsSlot].
 */
public suspend fun webAppSitePushSettingsSlot(
    name: String,
    block: suspend WebAppSitePushSettingsSlotResourceBuilder.() -> Unit,
):
    WebAppSitePushSettingsSlot {
    val builder = WebAppSitePushSettingsSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSitePushSettingsSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSitePushSettingsSlot(name: String): WebAppSitePushSettingsSlot {
    val builder = WebAppSitePushSettingsSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
