@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ClientCertMode
import com.pulumi.azurenative.web.kotlin.enums.RedundancyMode
import com.pulumi.azurenative.web.kotlin.inputs.CloningInfoArgs
import com.pulumi.azurenative.web.kotlin.inputs.CloningInfoArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.web.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.HostNameSslStateArgs
import com.pulumi.azurenative.web.kotlin.inputs.HostNameSslStateArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.HostingEnvironmentProfileArgs
import com.pulumi.azurenative.web.kotlin.inputs.HostingEnvironmentProfileArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.web.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.SiteConfigArgs
import com.pulumi.azurenative.web.kotlin.inputs.SiteConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A web app, a mobile app backend, or an API app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2018-11-01, 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Clone web app slot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppSlot = new AzureNative.Web.WebAppSlot("webAppSlot", new()
 *     {
 *         CloningInfo = new AzureNative.Web.Inputs.CloningInfoArgs
 *         {
 *             AppSettingsOverrides =
 *             {
 *                 { "Setting1", "NewValue1" },
 *                 { "Setting3", "NewValue5" },
 *             },
 *             CloneCustomHostNames = true,
 *             CloneSourceControl = true,
 *             ConfigureLoadBalancing = false,
 *             HostingEnvironment = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/hostingenvironments/aseforsites",
 *             Overwrite = false,
 *             SourceWebAppId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/sites/srcsiteg478/slot/qa",
 *             SourceWebAppLocation = "West Europe",
 *         },
 *         Kind = "app",
 *         Location = "East US",
 *         Name = "sitef6141",
 *         ResourceGroupName = "testrg123",
 *         Slot = "staging",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppSlot(ctx, "webAppSlot", &web.WebAppSlotArgs{
 * 			CloningInfo: &web.CloningInfoArgs{
 * 				AppSettingsOverrides: pulumi.StringMap{
 * 					"Setting1": pulumi.String("NewValue1"),
 * 					"Setting3": pulumi.String("NewValue5"),
 * 				},
 * 				CloneCustomHostNames:   pulumi.Bool(true),
 * 				CloneSourceControl:     pulumi.Bool(true),
 * 				ConfigureLoadBalancing: pulumi.Bool(false),
 * 				HostingEnvironment:     pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/hostingenvironments/aseforsites"),
 * 				Overwrite:              pulumi.Bool(false),
 * 				SourceWebAppId:         pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/sites/srcsiteg478/slot/qa"),
 * 				SourceWebAppLocation:   pulumi.String("West Europe"),
 * 			},
 * 			Kind:              pulumi.String("app"),
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("sitef6141"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Slot:              pulumi.String("staging"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppSlot;
 * import com.pulumi.azurenative.web.WebAppSlotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppSlot = new WebAppSlot("webAppSlot", WebAppSlotArgs.builder()
 *             .cloningInfo(Map.ofEntries(
 *                 Map.entry("appSettingsOverrides", Map.ofEntries(
 *                     Map.entry("Setting1", "NewValue1"),
 *                     Map.entry("Setting3", "NewValue5")
 *                 )),
 *                 Map.entry("cloneCustomHostNames", true),
 *                 Map.entry("cloneSourceControl", true),
 *                 Map.entry("configureLoadBalancing", false),
 *                 Map.entry("hostingEnvironment", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/hostingenvironments/aseforsites"),
 *                 Map.entry("overwrite", false),
 *                 Map.entry("sourceWebAppId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg456/providers/Microsoft.Web/sites/srcsiteg478/slot/qa"),
 *                 Map.entry("sourceWebAppLocation", "West Europe")
 *             ))
 *             .kind("app")
 *             .location("East US")
 *             .name("sitef6141")
 *             .resourceGroupName("testrg123")
 *             .slot("staging")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Web App Slot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppSlot = new AzureNative.Web.WebAppSlot("webAppSlot", new()
 *     {
 *         Kind = "app",
 *         Location = "East US",
 *         Name = "sitef6141",
 *         ResourceGroupName = "testrg123",
 *         ServerFarmId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp",
 *         Slot = "staging",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppSlot(ctx, "webAppSlot", &web.WebAppSlotArgs{
 * 			Kind:              pulumi.String("app"),
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("sitef6141"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			ServerFarmId:      pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp"),
 * 			Slot:              pulumi.String("staging"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppSlot;
 * import com.pulumi.azurenative.web.WebAppSlotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppSlot = new WebAppSlot("webAppSlot", WebAppSlotArgs.builder()
 *             .kind("app")
 *             .location("East US")
 *             .name("sitef6141")
 *             .resourceGroupName("testrg123")
 *             .serverFarmId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Web/serverfarms/DefaultAsp")
 *             .slot("staging")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSlot sitef6141/staging /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}
 * ```
 * @property clientAffinityEnabled <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
 * @property clientCertEnabled <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
 * @property clientCertExclusionPaths client certificate authentication comma-separated exclusion paths
 * @property clientCertMode This composes with ClientCertEnabled setting.
 * - ClientCertEnabled: false means ClientCert is ignored.
 * - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
 * - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
 * @property cloningInfo If specified during app creation, the app is cloned from a source app.
 * @property containerSize Size of the function container.
 * @property customDomainVerificationId Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
 * @property dailyMemoryTimeQuota Maximum allowed daily memory-time quota (applicable on dynamic apps only).
 * @property enabled <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
 * @property extendedLocation Extended Location.
 * @property hostNameSslStates Hostname SSL states are used to manage the SSL bindings for app's hostnames.
 * @property hostNamesDisabled <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
 *  If <code>true</code>, the app is only accessible via API management process.
 * @property hostingEnvironmentProfile App Service Environment to use for the app.
 * @property httpsOnly HttpsOnly: configures a web site to accept only https requests. Issues redirect for
 * http requests
 * @property hyperV Hyper-V sandbox.
 * @property identity Managed service identity.
 * @property isXenon Obsolete: Hyper-V sandbox.
 * @property keyVaultReferenceIdentity Identity to use for Key Vault Reference authentication.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property managedEnvironmentId Azure Resource Manager ID of the customer's selected Managed Environment on which to host this app. This must be of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}
 * @property name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
 * @property publicNetworkAccess Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
 * @property redundancyMode Site redundancy mode
 * @property reserved <code>true</code> if reserved; otherwise, <code>false</code>.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property scmSiteAlsoStopped <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
 * @property serverFarmId Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
 * @property siteConfig Configuration of the app.
 * @property slot Name of the deployment slot to create or update. By default, this API attempts to create or modify the production slot.
 * @property storageAccountRequired Checks if Customer provided storage account is required
 * @property tags Resource tags.
 * @property virtualNetworkSubnetId Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration.
 * This must be of the form /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
 * @property vnetContentShareEnabled To enable accessing content over virtual network
 * @property vnetImagePullEnabled To enable pulling image over Virtual Network
 * @property vnetRouteAllEnabled Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
 */
public data class WebAppSlotArgs(
    public val clientAffinityEnabled: Output<Boolean>? = null,
    public val clientCertEnabled: Output<Boolean>? = null,
    public val clientCertExclusionPaths: Output<String>? = null,
    public val clientCertMode: Output<ClientCertMode>? = null,
    public val cloningInfo: Output<CloningInfoArgs>? = null,
    public val containerSize: Output<Int>? = null,
    public val customDomainVerificationId: Output<String>? = null,
    public val dailyMemoryTimeQuota: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hostNameSslStates: Output<List<HostNameSslStateArgs>>? = null,
    public val hostNamesDisabled: Output<Boolean>? = null,
    public val hostingEnvironmentProfile: Output<HostingEnvironmentProfileArgs>? = null,
    public val httpsOnly: Output<Boolean>? = null,
    public val hyperV: Output<Boolean>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val isXenon: Output<Boolean>? = null,
    public val keyVaultReferenceIdentity: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedEnvironmentId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val redundancyMode: Output<RedundancyMode>? = null,
    public val reserved: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scmSiteAlsoStopped: Output<Boolean>? = null,
    public val serverFarmId: Output<String>? = null,
    public val siteConfig: Output<SiteConfigArgs>? = null,
    public val slot: Output<String>? = null,
    public val storageAccountRequired: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetworkSubnetId: Output<String>? = null,
    public val vnetContentShareEnabled: Output<Boolean>? = null,
    public val vnetImagePullEnabled: Output<Boolean>? = null,
    public val vnetRouteAllEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSlotArgs =
        com.pulumi.azurenative.web.WebAppSlotArgs.builder()
            .clientAffinityEnabled(clientAffinityEnabled?.applyValue({ args0 -> args0 }))
            .clientCertEnabled(clientCertEnabled?.applyValue({ args0 -> args0 }))
            .clientCertExclusionPaths(clientCertExclusionPaths?.applyValue({ args0 -> args0 }))
            .clientCertMode(clientCertMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cloningInfo(cloningInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerSize(containerSize?.applyValue({ args0 -> args0 }))
            .customDomainVerificationId(customDomainVerificationId?.applyValue({ args0 -> args0 }))
            .dailyMemoryTimeQuota(dailyMemoryTimeQuota?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostNameSslStates(
                hostNameSslStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hostNamesDisabled(hostNamesDisabled?.applyValue({ args0 -> args0 }))
            .hostingEnvironmentProfile(
                hostingEnvironmentProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpsOnly(httpsOnly?.applyValue({ args0 -> args0 }))
            .hyperV(hyperV?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isXenon(isXenon?.applyValue({ args0 -> args0 }))
            .keyVaultReferenceIdentity(keyVaultReferenceIdentity?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedEnvironmentId(managedEnvironmentId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .redundancyMode(redundancyMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reserved(reserved?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scmSiteAlsoStopped(scmSiteAlsoStopped?.applyValue({ args0 -> args0 }))
            .serverFarmId(serverFarmId?.applyValue({ args0 -> args0 }))
            .siteConfig(siteConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .storageAccountRequired(storageAccountRequired?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetworkSubnetId(virtualNetworkSubnetId?.applyValue({ args0 -> args0 }))
            .vnetContentShareEnabled(vnetContentShareEnabled?.applyValue({ args0 -> args0 }))
            .vnetImagePullEnabled(vnetImagePullEnabled?.applyValue({ args0 -> args0 }))
            .vnetRouteAllEnabled(vnetRouteAllEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSlotArgs].
 */
@PulumiTagMarker
public class WebAppSlotArgsBuilder internal constructor() {
    private var clientAffinityEnabled: Output<Boolean>? = null

    private var clientCertEnabled: Output<Boolean>? = null

    private var clientCertExclusionPaths: Output<String>? = null

    private var clientCertMode: Output<ClientCertMode>? = null

    private var cloningInfo: Output<CloningInfoArgs>? = null

    private var containerSize: Output<Int>? = null

    private var customDomainVerificationId: Output<String>? = null

    private var dailyMemoryTimeQuota: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hostNameSslStates: Output<List<HostNameSslStateArgs>>? = null

    private var hostNamesDisabled: Output<Boolean>? = null

    private var hostingEnvironmentProfile: Output<HostingEnvironmentProfileArgs>? = null

    private var httpsOnly: Output<Boolean>? = null

    private var hyperV: Output<Boolean>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var isXenon: Output<Boolean>? = null

    private var keyVaultReferenceIdentity: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedEnvironmentId: Output<String>? = null

    private var name: Output<String>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var redundancyMode: Output<RedundancyMode>? = null

    private var reserved: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var scmSiteAlsoStopped: Output<Boolean>? = null

    private var serverFarmId: Output<String>? = null

    private var siteConfig: Output<SiteConfigArgs>? = null

    private var slot: Output<String>? = null

    private var storageAccountRequired: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetworkSubnetId: Output<String>? = null

    private var vnetContentShareEnabled: Output<Boolean>? = null

    private var vnetImagePullEnabled: Output<Boolean>? = null

    private var vnetRouteAllEnabled: Output<Boolean>? = null

    /**
     * @param value <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
     */
    @JvmName("xidiidaqqjtbvfxr")
    public suspend fun clientAffinityEnabled(`value`: Output<Boolean>) {
        this.clientAffinityEnabled = value
    }

    /**
     * @param value <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
     */
    @JvmName("xyctitxjfxubhgeg")
    public suspend fun clientCertEnabled(`value`: Output<Boolean>) {
        this.clientCertEnabled = value
    }

    /**
     * @param value client certificate authentication comma-separated exclusion paths
     */
    @JvmName("peevvviernjldiek")
    public suspend fun clientCertExclusionPaths(`value`: Output<String>) {
        this.clientCertExclusionPaths = value
    }

    /**
     * @param value This composes with ClientCertEnabled setting.
     * - ClientCertEnabled: false means ClientCert is ignored.
     * - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
     */
    @JvmName("lsphdxhyglislwyq")
    public suspend fun clientCertMode(`value`: Output<ClientCertMode>) {
        this.clientCertMode = value
    }

    /**
     * @param value If specified during app creation, the app is cloned from a source app.
     */
    @JvmName("amiugtcfqhkckfwt")
    public suspend fun cloningInfo(`value`: Output<CloningInfoArgs>) {
        this.cloningInfo = value
    }

    /**
     * @param value Size of the function container.
     */
    @JvmName("abephvoxfykmppps")
    public suspend fun containerSize(`value`: Output<Int>) {
        this.containerSize = value
    }

    /**
     * @param value Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
     */
    @JvmName("tqqqsakekxxwmkyg")
    public suspend fun customDomainVerificationId(`value`: Output<String>) {
        this.customDomainVerificationId = value
    }

    /**
     * @param value Maximum allowed daily memory-time quota (applicable on dynamic apps only).
     */
    @JvmName("jqgskspoorlgpmdo")
    public suspend fun dailyMemoryTimeQuota(`value`: Output<Int>) {
        this.dailyMemoryTimeQuota = value
    }

    /**
     * @param value <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
     */
    @JvmName("ghnwbqqjgluesnrf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Extended Location.
     */
    @JvmName("rgplxkwwjuxxfslo")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("qdkwiradeqmvvemk")
    public suspend fun hostNameSslStates(`value`: Output<List<HostNameSslStateArgs>>) {
        this.hostNameSslStates = value
    }

    @JvmName("ladtdblsgojjerhx")
    public suspend fun hostNameSslStates(vararg values: Output<HostNameSslStateArgs>) {
        this.hostNameSslStates = Output.all(values.asList())
    }

    /**
     * @param values Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("npxjtwuwbstuunpc")
    public suspend fun hostNameSslStates(values: List<Output<HostNameSslStateArgs>>) {
        this.hostNameSslStates = Output.all(values)
    }

    /**
     * @param value <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
     *  If <code>true</code>, the app is only accessible via API management process.
     */
    @JvmName("ltbmnacurqfcgvct")
    public suspend fun hostNamesDisabled(`value`: Output<Boolean>) {
        this.hostNamesDisabled = value
    }

    /**
     * @param value App Service Environment to use for the app.
     */
    @JvmName("plhjjsgpdfjkgjaa")
    public suspend fun hostingEnvironmentProfile(`value`: Output<HostingEnvironmentProfileArgs>) {
        this.hostingEnvironmentProfile = value
    }

    /**
     * @param value HttpsOnly: configures a web site to accept only https requests. Issues redirect for
     * http requests
     */
    @JvmName("nnudswdjmdtgigmb")
    public suspend fun httpsOnly(`value`: Output<Boolean>) {
        this.httpsOnly = value
    }

    /**
     * @param value Hyper-V sandbox.
     */
    @JvmName("himkdviaxnicgsxh")
    public suspend fun hyperV(`value`: Output<Boolean>) {
        this.hyperV = value
    }

    /**
     * @param value Managed service identity.
     */
    @JvmName("aesvhfkgpeibqjni")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Obsolete: Hyper-V sandbox.
     */
    @JvmName("asclafvoncbaxxni")
    public suspend fun isXenon(`value`: Output<Boolean>) {
        this.isXenon = value
    }

    /**
     * @param value Identity to use for Key Vault Reference authentication.
     */
    @JvmName("fbgxlgearrhyoxml")
    public suspend fun keyVaultReferenceIdentity(`value`: Output<String>) {
        this.keyVaultReferenceIdentity = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("yidkofaqmrshyqul")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("xqvhmdpxqppcxiej")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure Resource Manager ID of the customer's selected Managed Environment on which to host this app. This must be of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}
     */
    @JvmName("muoenqodoohvfjsr")
    public suspend fun managedEnvironmentId(`value`: Output<String>) {
        this.managedEnvironmentId = value
    }

    /**
     * @param value Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     */
    @JvmName("omctvwbuhegqhvmg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     */
    @JvmName("vrlfthphjiwplnlt")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Site redundancy mode
     */
    @JvmName("lnsrwvggxsgxcxar")
    public suspend fun redundancyMode(`value`: Output<RedundancyMode>) {
        this.redundancyMode = value
    }

    /**
     * @param value <code>true</code> if reserved; otherwise, <code>false</code>.
     */
    @JvmName("urtsvovmmukduavl")
    public suspend fun reserved(`value`: Output<Boolean>) {
        this.reserved = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ytvfiuvaxabyaiiu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
     */
    @JvmName("ifkidqrsrqpclpgj")
    public suspend fun scmSiteAlsoStopped(`value`: Output<Boolean>) {
        this.scmSiteAlsoStopped = value
    }

    /**
     * @param value Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     */
    @JvmName("vdmfgnoccbxnrgfw")
    public suspend fun serverFarmId(`value`: Output<String>) {
        this.serverFarmId = value
    }

    /**
     * @param value Configuration of the app.
     */
    @JvmName("sbxllgwttuhqtbrr")
    public suspend fun siteConfig(`value`: Output<SiteConfigArgs>) {
        this.siteConfig = value
    }

    /**
     * @param value Name of the deployment slot to create or update. By default, this API attempts to create or modify the production slot.
     */
    @JvmName("qdsdxahjnexgsnqs")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Checks if Customer provided storage account is required
     */
    @JvmName("rypsgudqnrfbwmdp")
    public suspend fun storageAccountRequired(`value`: Output<Boolean>) {
        this.storageAccountRequired = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xxibmvdmwoxqtuan")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration.
     * This must be of the form /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
     */
    @JvmName("htdqcwubxpfsuvhs")
    public suspend fun virtualNetworkSubnetId(`value`: Output<String>) {
        this.virtualNetworkSubnetId = value
    }

    /**
     * @param value To enable accessing content over virtual network
     */
    @JvmName("dxlveyqumfoqdhyw")
    public suspend fun vnetContentShareEnabled(`value`: Output<Boolean>) {
        this.vnetContentShareEnabled = value
    }

    /**
     * @param value To enable pulling image over Virtual Network
     */
    @JvmName("iuynfchcrklyayij")
    public suspend fun vnetImagePullEnabled(`value`: Output<Boolean>) {
        this.vnetImagePullEnabled = value
    }

    /**
     * @param value Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JvmName("ruvfsnohdlfgdeiy")
    public suspend fun vnetRouteAllEnabled(`value`: Output<Boolean>) {
        this.vnetRouteAllEnabled = value
    }

    /**
     * @param value <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
     */
    @JvmName("xohosuxowafincdv")
    public suspend fun clientAffinityEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAffinityEnabled = mapped
    }

    /**
     * @param value <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
     */
    @JvmName("gwjxwlehafiedoka")
    public suspend fun clientCertEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertEnabled = mapped
    }

    /**
     * @param value client certificate authentication comma-separated exclusion paths
     */
    @JvmName("cfleouyffmgcwmxo")
    public suspend fun clientCertExclusionPaths(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertExclusionPaths = mapped
    }

    /**
     * @param value This composes with ClientCertEnabled setting.
     * - ClientCertEnabled: false means ClientCert is ignored.
     * - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
     */
    @JvmName("dpptjcyhbectcsbx")
    public suspend fun clientCertMode(`value`: ClientCertMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertMode = mapped
    }

    /**
     * @param value If specified during app creation, the app is cloned from a source app.
     */
    @JvmName("ybajaqqbcpipkwvc")
    public suspend fun cloningInfo(`value`: CloningInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloningInfo = mapped
    }

    /**
     * @param argument If specified during app creation, the app is cloned from a source app.
     */
    @JvmName("aanflsxrpggpbcdr")
    public suspend fun cloningInfo(argument: suspend CloningInfoArgsBuilder.() -> Unit) {
        val toBeMapped = CloningInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloningInfo = mapped
    }

    /**
     * @param value Size of the function container.
     */
    @JvmName("fugxpkhtynfujsgo")
    public suspend fun containerSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerSize = mapped
    }

    /**
     * @param value Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
     */
    @JvmName("cyejrwllchlnlfup")
    public suspend fun customDomainVerificationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomainVerificationId = mapped
    }

    /**
     * @param value Maximum allowed daily memory-time quota (applicable on dynamic apps only).
     */
    @JvmName("senuvxlxroeamyyb")
    public suspend fun dailyMemoryTimeQuota(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyMemoryTimeQuota = mapped
    }

    /**
     * @param value <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
     */
    @JvmName("dofmmumqncxiwghg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Extended Location.
     */
    @JvmName("onfclrmtqmjlhmkc")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location.
     */
    @JvmName("mbaulqenvpgpuner")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("rtxaubcqoonbwijn")
    public suspend fun hostNameSslStates(`value`: List<HostNameSslStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNameSslStates = mapped
    }

    /**
     * @param argument Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("pmkbdkebdtdjgcbk")
    public suspend
    fun hostNameSslStates(argument: List<suspend HostNameSslStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HostNameSslStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostNameSslStates = mapped
    }

    /**
     * @param argument Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("hjwmayhhpkpketjp")
    public suspend fun hostNameSslStates(
        vararg
        argument: suspend HostNameSslStateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HostNameSslStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostNameSslStates = mapped
    }

    /**
     * @param argument Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("liqndlfohnkhvrji")
    public suspend fun hostNameSslStates(argument: suspend HostNameSslStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HostNameSslStateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hostNameSslStates = mapped
    }

    /**
     * @param values Hostname SSL states are used to manage the SSL bindings for app's hostnames.
     */
    @JvmName("cqxjwodubuvypnth")
    public suspend fun hostNameSslStates(vararg values: HostNameSslStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostNameSslStates = mapped
    }

    /**
     * @param value <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
     *  If <code>true</code>, the app is only accessible via API management process.
     */
    @JvmName("paugsaugcjvitcmp")
    public suspend fun hostNamesDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNamesDisabled = mapped
    }

    /**
     * @param value App Service Environment to use for the app.
     */
    @JvmName("bjgbapuhvoaijagt")
    public suspend fun hostingEnvironmentProfile(`value`: HostingEnvironmentProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostingEnvironmentProfile = mapped
    }

    /**
     * @param argument App Service Environment to use for the app.
     */
    @JvmName("dhecddyjpxxejala")
    public suspend
    fun hostingEnvironmentProfile(argument: suspend HostingEnvironmentProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HostingEnvironmentProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostingEnvironmentProfile = mapped
    }

    /**
     * @param value HttpsOnly: configures a web site to accept only https requests. Issues redirect for
     * http requests
     */
    @JvmName("vhnqlmjdjkwfawlr")
    public suspend fun httpsOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsOnly = mapped
    }

    /**
     * @param value Hyper-V sandbox.
     */
    @JvmName("ocdqshenbettllpx")
    public suspend fun hyperV(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperV = mapped
    }

    /**
     * @param value Managed service identity.
     */
    @JvmName("dlttrjkbaauunvhu")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity.
     */
    @JvmName("rbfhqtimblwjagft")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Obsolete: Hyper-V sandbox.
     */
    @JvmName("blhhykhpsyeftxvq")
    public suspend fun isXenon(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isXenon = mapped
    }

    /**
     * @param value Identity to use for Key Vault Reference authentication.
     */
    @JvmName("mlnuaikxqcjvdheu")
    public suspend fun keyVaultReferenceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultReferenceIdentity = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("aioyvsfaninaiald")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("vqdxucgbshcktrew")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure Resource Manager ID of the customer's selected Managed Environment on which to host this app. This must be of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}
     */
    @JvmName("llgminhknnkacacb")
    public suspend fun managedEnvironmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedEnvironmentId = mapped
    }

    /**
     * @param value Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     */
    @JvmName("xgxqtahuahthfhlo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     */
    @JvmName("wnrfupxhiashhkba")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Site redundancy mode
     */
    @JvmName("wylnhurwqftlbuef")
    public suspend fun redundancyMode(`value`: RedundancyMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redundancyMode = mapped
    }

    /**
     * @param value <code>true</code> if reserved; otherwise, <code>false</code>.
     */
    @JvmName("scapaakecaupeeot")
    public suspend fun reserved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reserved = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("daxcognqewvijmou")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
     */
    @JvmName("enoimkjiixwalukk")
    public suspend fun scmSiteAlsoStopped(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmSiteAlsoStopped = mapped
    }

    /**
     * @param value Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     */
    @JvmName("bkhnojbwkspxrrxu")
    public suspend fun serverFarmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverFarmId = mapped
    }

    /**
     * @param value Configuration of the app.
     */
    @JvmName("devmknfkiwsqwaak")
    public suspend fun siteConfig(`value`: SiteConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteConfig = mapped
    }

    /**
     * @param argument Configuration of the app.
     */
    @JvmName("ostjhpftjbfyehmi")
    public suspend fun siteConfig(argument: suspend SiteConfigArgsBuilder.() -> Unit) {
        val toBeMapped = SiteConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.siteConfig = mapped
    }

    /**
     * @param value Name of the deployment slot to create or update. By default, this API attempts to create or modify the production slot.
     */
    @JvmName("nbmiqajfybtfovah")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value Checks if Customer provided storage account is required
     */
    @JvmName("bltbrcqtjsikqvix")
    public suspend fun storageAccountRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountRequired = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wsufhasnyoaiavhi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cvugonpbamvqlyrx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration.
     * This must be of the form /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
     */
    @JvmName("vphmmxigfymbnips")
    public suspend fun virtualNetworkSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkSubnetId = mapped
    }

    /**
     * @param value To enable accessing content over virtual network
     */
    @JvmName("ionlswaqwcuflyqd")
    public suspend fun vnetContentShareEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetContentShareEnabled = mapped
    }

    /**
     * @param value To enable pulling image over Virtual Network
     */
    @JvmName("bjvhlyidloxxruiv")
    public suspend fun vnetImagePullEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetImagePullEnabled = mapped
    }

    /**
     * @param value Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JvmName("ottnueadqjoinhja")
    public suspend fun vnetRouteAllEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetRouteAllEnabled = mapped
    }

    internal fun build(): WebAppSlotArgs = WebAppSlotArgs(
        clientAffinityEnabled = clientAffinityEnabled,
        clientCertEnabled = clientCertEnabled,
        clientCertExclusionPaths = clientCertExclusionPaths,
        clientCertMode = clientCertMode,
        cloningInfo = cloningInfo,
        containerSize = containerSize,
        customDomainVerificationId = customDomainVerificationId,
        dailyMemoryTimeQuota = dailyMemoryTimeQuota,
        enabled = enabled,
        extendedLocation = extendedLocation,
        hostNameSslStates = hostNameSslStates,
        hostNamesDisabled = hostNamesDisabled,
        hostingEnvironmentProfile = hostingEnvironmentProfile,
        httpsOnly = httpsOnly,
        hyperV = hyperV,
        identity = identity,
        isXenon = isXenon,
        keyVaultReferenceIdentity = keyVaultReferenceIdentity,
        kind = kind,
        location = location,
        managedEnvironmentId = managedEnvironmentId,
        name = name,
        publicNetworkAccess = publicNetworkAccess,
        redundancyMode = redundancyMode,
        reserved = reserved,
        resourceGroupName = resourceGroupName,
        scmSiteAlsoStopped = scmSiteAlsoStopped,
        serverFarmId = serverFarmId,
        siteConfig = siteConfig,
        slot = slot,
        storageAccountRequired = storageAccountRequired,
        tags = tags,
        virtualNetworkSubnetId = virtualNetworkSubnetId,
        vnetContentShareEnabled = vnetContentShareEnabled,
        vnetImagePullEnabled = vnetImagePullEnabled,
        vnetRouteAllEnabled = vnetRouteAllEnabled,
    )
}
