@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The API type
 */
public enum class ApiType(
    public val javaValue: com.pulumi.azurenative.web.enums.ApiType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.ApiType> {
    NotSpecified(com.pulumi.azurenative.web.enums.ApiType.NotSpecified),
    Rest(com.pulumi.azurenative.web.enums.ApiType.Rest),
    Soap(com.pulumi.azurenative.web.enums.ApiType.Soap),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.ApiType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.ApiType): ApiType =
            ApiType.values().first { it.javaValue == javaType }
    }
}
