@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This composes with ClientCertEnabled setting.
 * - ClientCertEnabled: false means ClientCert is ignored.
 * - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
 * - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
 */
public enum class ClientCertMode(
    public val javaValue: com.pulumi.azurenative.web.enums.ClientCertMode,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.ClientCertMode> {
    Required(com.pulumi.azurenative.web.enums.ClientCertMode.Required),
    Optional(com.pulumi.azurenative.web.enums.ClientCertMode.Optional),
    OptionalInteractiveUser(com.pulumi.azurenative.web.enums.ClientCertMode.OptionalInteractiveUser),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.ClientCertMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.ClientCertMode): ClientCertMode =
            ClientCertMode.values().first { it.javaValue == javaType }
    }
}
