@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the parameter
 */
public enum class ConnectionParameterType(
    public val javaValue: com.pulumi.azurenative.web.enums.ConnectionParameterType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.ConnectionParameterType> {
    String(com.pulumi.azurenative.web.enums.ConnectionParameterType.String),
    Securestring(com.pulumi.azurenative.web.enums.ConnectionParameterType.Securestring),
    Secureobject(com.pulumi.azurenative.web.enums.ConnectionParameterType.Secureobject),
    Int_(com.pulumi.azurenative.web.enums.ConnectionParameterType.Int_),
    Bool(com.pulumi.azurenative.web.enums.ConnectionParameterType.Bool),
    Object(com.pulumi.azurenative.web.enums.ConnectionParameterType.Object),
    Array(com.pulumi.azurenative.web.enums.ConnectionParameterType.Array),
    OauthSetting(com.pulumi.azurenative.web.enums.ConnectionParameterType.OauthSetting),
    Connection(com.pulumi.azurenative.web.enums.ConnectionParameterType.Connection),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.ConnectionParameterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.ConnectionParameterType):
            ConnectionParameterType =
            ConnectionParameterType.values().first { it.javaValue == javaType }
    }
}
