@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Default action for scm access restriction if no rules are matched.
 */
public enum class DefaultAction(
    public val javaValue: com.pulumi.azurenative.web.enums.DefaultAction,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.DefaultAction> {
    Allow(com.pulumi.azurenative.web.enums.DefaultAction.Allow),
    Deny(com.pulumi.azurenative.web.enums.DefaultAction.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.DefaultAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.DefaultAction): DefaultAction =
            DefaultAction.values().first { it.javaValue == javaType }
    }
}
