@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of route this is:
 * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
 * INHERITED - Routes inherited from the real Virtual Network routes
 * STATIC - Static route set on the app only
 * These values will be used for syncing an app's routes with those from a Virtual Network.
 */
public enum class RouteType(
    public val javaValue: com.pulumi.azurenative.web.enums.RouteType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.RouteType> {
    DEFAULT(com.pulumi.azurenative.web.enums.RouteType.DEFAULT),
    INHERITED(com.pulumi.azurenative.web.enums.RouteType.INHERITED),
    STATIC(com.pulumi.azurenative.web.enums.RouteType.STATIC),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.RouteType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.RouteType): RouteType =
            RouteType.values().first { it.javaValue == javaType }
    }
}
